/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.storage.transform;

import com.dianping.cat.home.storage.IEntity;
import com.dianping.cat.home.storage.entity.Link;
import com.dianping.cat.home.storage.entity.Machine;
import com.dianping.cat.home.storage.entity.Storage;
import com.dianping.cat.home.storage.entity.StorageGroup;
import com.dianping.cat.home.storage.entity.StorageGroupConfig;
import com.dianping.cat.home.storage.transform.DefaultLinker;
import com.dianping.cat.home.storage.transform.DefaultSaxMaker;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static StorageGroupConfig parse(InputSource is) throws SAXException, IOException {
        return (StorageGroupConfig)DefaultSaxParser.parseEntity(StorageGroupConfig.class, (InputSource)is);
    }

    public static StorageGroupConfig parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(in));
    }

    public static StorageGroupConfig parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(reader));
    }

    public static StorageGroupConfig parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return (T)DefaultSaxParser.parseEntity(type, (InputSource)new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            Object currentObj = this.m_objs.pop();
            String currentTag = (String)this.m_tags.pop();
            if (currentObj instanceof Link) {
                Link link = (Link)currentObj;
                if ("par".equals(currentTag)) {
                    link.addPar(this.getText());
                }
            }
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForLink(Link parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"pars".equals(qName) && !"par".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under link!", qName));
        }
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForMachine(Machine parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForStorage(Storage parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"machine".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under storage!", qName));
        }
        Machine machine = this.m_maker.buildMachine(attributes);
        this.m_linker.onMachine(parentObj, machine);
        this.m_objs.push(machine);
        this.m_tags.push(qName);
    }

    private void parseForStorageGroup(StorageGroup parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("link".equals(qName)) {
            Link link = this.m_maker.buildLink(attributes);
            this.m_linker.onLink(parentObj, link);
            this.m_objs.push(link);
        } else if ("storage".equals(qName)) {
            Storage storage = this.m_maker.buildStorage(attributes);
            this.m_linker.onStorage(parentObj, storage);
            this.m_objs.push(storage);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under storage-group!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForStorageGroupConfig(StorageGroupConfig parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"storage-group".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under storage-group-config!", qName));
        }
        StorageGroup storageGroup = this.m_maker.buildStorageGroup(attributes);
        this.m_linker.onStorageGroup(parentObj, storageGroup);
        this.m_objs.push(storageGroup);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("storage-group-config".equals(qName)) {
            StorageGroupConfig storageGroupConfig = this.m_maker.buildStorageGroupConfig(attributes);
            this.m_entity = storageGroupConfig;
            this.m_objs.push(storageGroupConfig);
            this.m_tags.push(qName);
        } else if ("storage-group".equals(qName)) {
            StorageGroup storageGroup = this.m_maker.buildStorageGroup(attributes);
            this.m_entity = storageGroup;
            this.m_objs.push(storageGroup);
            this.m_tags.push(qName);
        } else if ("link".equals(qName)) {
            Link link = this.m_maker.buildLink(attributes);
            this.m_entity = link;
            this.m_objs.push(link);
            this.m_tags.push(qName);
        } else if ("storage".equals(qName)) {
            Storage storage = this.m_maker.buildStorage(attributes);
            this.m_entity = storage;
            this.m_objs.push(storage);
            this.m_tags.push(qName);
        } else if ("machine".equals(qName)) {
            Machine machine = this.m_maker.buildMachine(attributes);
            this.m_entity = machine;
            this.m_objs.push(machine);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof StorageGroupConfig) {
                this.parseForStorageGroupConfig((StorageGroupConfig)parent, tag, qName, attributes);
            } else if (parent instanceof StorageGroup) {
                this.parseForStorageGroup((StorageGroup)parent, tag, qName, attributes);
            } else if (parent instanceof Link) {
                this.parseForLink((Link)parent, tag, qName, attributes);
            } else if (parent instanceof Storage) {
                this.parseForStorage((Storage)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof Machine)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForMachine((Machine)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

