/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.system.entity;

import com.dianping.cat.home.system.BaseEntity;
import com.dianping.cat.home.system.IVisitor;
import com.dianping.cat.home.system.entity.Entity;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain
extends BaseEntity<Domain> {
    private String m_id;
    private Map<String, Entity> m_entities = new LinkedHashMap();

    public Domain() {
    }

    public Domain(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitDomain(this);
    }

    public Domain addEntity(Entity entity) {
        this.m_entities.put(entity.getId(), entity);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Domain) {
            Domain _o = (Domain)obj;
            return this.equals((Object)this.m_id, (Object)_o.getId());
        }
        return false;
    }

    public Entity findEntity(String id) {
        return (Entity)this.m_entities.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity findOrCreateEntity(String id) {
        Entity entity = (Entity)this.m_entities.get(id);
        if (entity == null) {
            Map map = this.m_entities;
            synchronized (map) {
                entity = (Entity)this.m_entities.get(id);
                if (entity == null) {
                    entity = new Entity(id);
                    this.m_entities.put(id, entity);
                }
            }
        }
        return entity;
    }

    public Map<String, Entity> getEntities() {
        return this.m_entities;
    }

    public String getId() {
        return this.m_id;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(Domain other) {
        this.assertAttributeEquals((Object)other, "domain", "id", (Object)this.m_id, (Object)other.getId());
    }

    public Entity removeEntity(String id) {
        return (Entity)this.m_entities.remove(id);
    }

    public Domain setId(String id) {
        this.m_id = id;
        return this;
    }
}

