/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.system.entity;

import com.dianping.cat.home.system.BaseEntity;
import com.dianping.cat.home.system.IVisitor;
import com.dianping.cat.home.system.entity.Day;
import com.dianping.cat.home.system.entity.Machine;
import com.dianping.cat.home.system.entity.Rush;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entity
extends BaseEntity<Entity> {
    private String m_id;
    private Rush m_rush;
    private Day m_day;
    private Map<String, Machine> m_machines = new LinkedHashMap();

    public Entity() {
    }

    public Entity(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitEntity(this);
    }

    public Entity addMachine(Machine machine) {
        this.m_machines.put(machine.getIp(), machine);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Entity) {
            Entity _o = (Entity)obj;
            return this.equals((Object)this.m_id, (Object)_o.getId());
        }
        return false;
    }

    public Machine findMachine(String ip) {
        return (Machine)this.m_machines.get(ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Machine findOrCreateMachine(String ip) {
        Machine machine = (Machine)this.m_machines.get(ip);
        if (machine == null) {
            Map map = this.m_machines;
            synchronized (map) {
                machine = (Machine)this.m_machines.get(ip);
                if (machine == null) {
                    machine = new Machine(ip);
                    this.m_machines.put(ip, machine);
                }
            }
        }
        return machine;
    }

    public Day getDay() {
        return this.m_day;
    }

    public String getId() {
        return this.m_id;
    }

    public Map<String, Machine> getMachines() {
        return this.m_machines;
    }

    public Rush getRush() {
        return this.m_rush;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(Entity other) {
        this.assertAttributeEquals((Object)other, "entity", "id", (Object)this.m_id, (Object)other.getId());
    }

    public Machine removeMachine(String ip) {
        return (Machine)this.m_machines.remove(ip);
    }

    public Entity setDay(Day day) {
        this.m_day = day;
        return this;
    }

    public Entity setId(String id) {
        this.m_id = id;
        return this;
    }

    public Entity setRush(Rush rush) {
        this.m_rush = rush;
        return this;
    }
}

