/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.system.entity;

import com.dianping.cat.home.system.BaseEntity;
import com.dianping.cat.home.system.IVisitor;
import com.dianping.cat.home.system.entity.Domain;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemReport
extends BaseEntity<SystemReport> {
    private Date m_startTime;
    private Date m_endTime;
    private Map<String, Domain> m_domains = new LinkedHashMap();

    public void accept(IVisitor visitor) {
        visitor.visitSystemReport(this);
    }

    public SystemReport addDomain(Domain domain) {
        this.m_domains.put(domain.getId(), domain);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SystemReport) {
            SystemReport _o = (SystemReport)obj;
            if (!this.equals((Object)this.m_startTime, (Object)_o.getStartTime())) {
                return false;
            }
            if (!this.equals((Object)this.m_endTime, (Object)_o.getEndTime())) {
                return false;
            }
            return this.equals((Object)this.m_domains, (Object)_o.getDomains());
        }
        return false;
    }

    public Domain findDomain(String id) {
        return (Domain)this.m_domains.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domain findOrCreateDomain(String id) {
        Domain domain = (Domain)this.m_domains.get(id);
        if (domain == null) {
            Map map = this.m_domains;
            synchronized (map) {
                domain = (Domain)this.m_domains.get(id);
                if (domain == null) {
                    domain = new Domain(id);
                    this.m_domains.put(id, domain);
                }
            }
        }
        return domain;
    }

    public Map<String, Domain> getDomains() {
        return this.m_domains;
    }

    public Date getEndTime() {
        return this.m_endTime;
    }

    public Date getStartTime() {
        return this.m_startTime;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_startTime == null ? 0 : this.m_startTime.hashCode());
        hash = hash * 31 + (this.m_endTime == null ? 0 : this.m_endTime.hashCode());
        hash = hash * 31 + (this.m_domains == null ? 0 : this.m_domains.hashCode());
        return hash;
    }

    public void mergeAttributes(SystemReport other) {
        if (other.getStartTime() != null) {
            this.m_startTime = other.getStartTime();
        }
        if (other.getEndTime() != null) {
            this.m_endTime = other.getEndTime();
        }
    }

    public Domain removeDomain(String id) {
        return (Domain)this.m_domains.remove(id);
    }

    public SystemReport setEndTime(Date endTime) {
        this.m_endTime = endTime;
        return this;
    }

    public SystemReport setStartTime(Date startTime) {
        this.m_startTime = startTime;
        return this;
    }
}

