/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.system.transform;

import com.dianping.cat.home.system.IVisitor;
import com.dianping.cat.home.system.entity.Day;
import com.dianping.cat.home.system.entity.Domain;
import com.dianping.cat.home.system.entity.Entity;
import com.dianping.cat.home.system.entity.Machine;
import com.dianping.cat.home.system.entity.Rush;
import com.dianping.cat.home.system.entity.SystemReport;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeBuilder
implements IVisitor {
    private IVisitor m_visitor;
    private DataOutputStream m_out;

    public DefaultNativeBuilder(OutputStream out) {
        this(out, null);
    }

    public DefaultNativeBuilder(OutputStream out, IVisitor visitor) {
        this.m_out = new DataOutputStream(out);
        this.m_visitor = visitor == null ? this : visitor;
    }

    public static byte[] build(SystemReport systemReport) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        DefaultNativeBuilder.build((SystemReport)systemReport, (OutputStream)out);
        return out.toByteArray();
    }

    public static void build(SystemReport systemReport, OutputStream out) {
        systemReport.accept((IVisitor)new DefaultNativeBuilder(out));
    }

    public void visitDay(Day day) {
        this.writeTag(1, 0);
        this.writeLong(day.getCount());
        this.writeTag(2, 0);
        this.writeDouble(day.getSum());
        this.writeTag(3, 0);
        this.writeDouble(day.getAvg());
        this.writeTag(63, 3);
    }

    public void visitDomain(Domain domain) {
        if (domain.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(domain.getId());
        }
        if (!domain.getEntities().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(domain.getEntities().size());
            for (Entity entity : domain.getEntities().values()) {
                entity.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitEntity(Entity entity) {
        if (entity.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(entity.getId());
        }
        if (entity.getRush() != null) {
            this.writeTag(33, 1);
            entity.getRush().accept(this.m_visitor);
        }
        if (entity.getDay() != null) {
            this.writeTag(34, 1);
            entity.getDay().accept(this.m_visitor);
        }
        if (!entity.getMachines().isEmpty()) {
            this.writeTag(35, 2);
            this.writeInt(entity.getMachines().size());
            for (Machine machine : entity.getMachines().values()) {
                machine.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitMachine(Machine machine) {
        if (machine.getIp() != null) {
            this.writeTag(1, 1);
            this.writeString(machine.getIp());
        }
        this.writeTag(63, 3);
    }

    public void visitRush(Rush rush) {
        this.writeTag(1, 0);
        this.writeLong(rush.getCount());
        this.writeTag(2, 0);
        this.writeDouble(rush.getSum());
        this.writeTag(3, 0);
        this.writeDouble(rush.getAvg());
        this.writeTag(63, 3);
    }

    public void visitSystemReport(SystemReport systemReport) {
        this.writeTag(63, 0);
        if (systemReport.getStartTime() != null) {
            this.writeTag(1, 1);
            this.writeDate(systemReport.getStartTime());
        }
        if (systemReport.getEndTime() != null) {
            this.writeTag(2, 1);
            this.writeDate(systemReport.getEndTime());
        }
        if (!systemReport.getDomains().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(systemReport.getDomains().size());
            for (Domain domain : systemReport.getDomains().values()) {
                domain.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    private void writeDate(Date value) {
        try {
            this.writeVarint(value.getTime());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDouble(double value) {
        try {
            this.writeVarint(Double.doubleToLongBits(value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeInt(int value) {
        try {
            this.writeVarint((long)value & 0xFFFFFFFFL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeLong(long value) {
        try {
            this.writeVarint(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeString(String value) {
        try {
            this.m_out.writeUTF(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTag(int field, int type) {
        try {
            this.m_out.writeByte((field << 2) + type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeVarint(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.m_out.writeByte((byte)value);
                return;
            }
            this.m_out.writeByte((byte)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }
}

