/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.system.transform;

import com.dianping.cat.home.system.IVisitor;
import com.dianping.cat.home.system.entity.Day;
import com.dianping.cat.home.system.entity.Domain;
import com.dianping.cat.home.system.entity.Entity;
import com.dianping.cat.home.system.entity.Machine;
import com.dianping.cat.home.system.entity.Rush;
import com.dianping.cat.home.system.entity.SystemReport;
import com.dianping.cat.home.system.transform.DefaultLinker;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeParser
implements IVisitor {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DataInputStream m_in;

    public DefaultNativeParser(InputStream in) {
        this.m_in = new DataInputStream(in);
    }

    public static SystemReport parse(byte[] data) {
        return DefaultNativeParser.parse((InputStream)new ByteArrayInputStream(data));
    }

    public static SystemReport parse(InputStream in) {
        SystemReport systemReport;
        DefaultNativeParser parser;
        block2: {
            parser = new DefaultNativeParser(in);
            systemReport = new SystemReport();
            try {
                systemReport.accept((IVisitor)parser);
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof EOFException) break block2;
                throw e;
            }
        }
        parser.m_linker.finish();
        return systemReport;
    }

    public void visitDay(Day day) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitDayChildren(day, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitDayChildren(Day day, int _field, int _type) {
        switch (_field) {
            case 1: {
                day.setCount(this.readLong());
                break;
            }
            case 2: {
                day.setSum(this.readDouble());
                break;
            }
            case 3: {
                day.setAvg(this.readDouble());
            }
        }
    }

    public void visitDomain(Domain domain) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitDomainChildren(domain, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitDomainChildren(Domain domain, int _field, int _type) {
        switch (_field) {
            case 1: {
                domain.setId(this.readString());
                break;
            }
            case 33: {
                if (_type == 1) {
                    Entity entities = new Entity();
                    this.visitEntity(entities);
                    this.m_linker.onEntity(domain, entities);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Entity entities = new Entity();
                    this.visitEntity(entities);
                    this.m_linker.onEntity(domain, entities);
                }
                break;
            }
        }
    }

    public void visitEntity(Entity entity) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitEntityChildren(entity, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitEntityChildren(Entity entity, int _field, int _type) {
        switch (_field) {
            case 1: {
                entity.setId(this.readString());
                break;
            }
            case 33: {
                Rush rush = new Rush();
                this.visitRush(rush);
                this.m_linker.onRush(entity, rush);
                break;
            }
            case 34: {
                Day day = new Day();
                this.visitDay(day);
                this.m_linker.onDay(entity, day);
                break;
            }
            case 35: {
                if (_type == 1) {
                    Machine machines = new Machine();
                    this.visitMachine(machines);
                    this.m_linker.onMachine(entity, machines);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Machine machines = new Machine();
                    this.visitMachine(machines);
                    this.m_linker.onMachine(entity, machines);
                }
                break;
            }
        }
    }

    public void visitMachine(Machine machine) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitMachineChildren(machine, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitMachineChildren(Machine machine, int _field, int _type) {
        switch (_field) {
            case 1: {
                machine.setIp(this.readString());
            }
        }
    }

    public void visitRush(Rush rush) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitRushChildren(rush, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitRushChildren(Rush rush, int _field, int _type) {
        switch (_field) {
            case 1: {
                rush.setCount(this.readLong());
                break;
            }
            case 2: {
                rush.setSum(this.readDouble());
                break;
            }
            case 3: {
                rush.setAvg(this.readDouble());
            }
        }
    }

    public void visitSystemReport(SystemReport systemReport) {
        byte tag = this.readTag();
        if (tag != -4) {
            throw new RuntimeException(String.format("Malformed payload, expected: %s, but was: %s!", -4, tag));
        }
        while ((tag = this.readTag()) != -1) {
            this.visitSystemReportChildren(systemReport, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitSystemReportChildren(SystemReport systemReport, int _field, int _type) {
        switch (_field) {
            case 1: {
                systemReport.setStartTime(this.readDate());
                break;
            }
            case 2: {
                systemReport.setEndTime(this.readDate());
                break;
            }
            case 33: {
                if (_type == 1) {
                    Domain domains = new Domain();
                    this.visitDomain(domains);
                    this.m_linker.onDomain(systemReport, domains);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Domain domains = new Domain();
                    this.visitDomain(domains);
                    this.m_linker.onDomain(systemReport, domains);
                }
                break;
            }
        }
    }

    private Date readDate() {
        try {
            return new Date(this.readVarint(64));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private double readDouble() {
        try {
            return Double.longBitsToDouble(this.readVarint(64));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int readInt() {
        try {
            return (int)this.readVarint(32);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private long readLong() {
        try {
            return this.readVarint(64);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readString() {
        try {
            return this.m_in.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte readTag() {
        try {
            return this.m_in.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected long readVarint(int length) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < length; shift += 7) {
            byte b = this.m_in.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new RuntimeException("Malformed variable int " + length + "!");
    }
}

