/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.system.transform;

import com.dianping.cat.home.system.entity.Day;
import com.dianping.cat.home.system.entity.Domain;
import com.dianping.cat.home.system.entity.Entity;
import com.dianping.cat.home.system.entity.Machine;
import com.dianping.cat.home.system.entity.Rush;
import com.dianping.cat.home.system.entity.SystemReport;
import com.dianping.cat.home.system.transform.IMaker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSaxMaker
implements IMaker<Attributes> {
    public Day buildDay(Attributes attributes) {
        String count = attributes.getValue("count");
        String sum = attributes.getValue("sum");
        String avg = attributes.getValue("avg");
        Day day = new Day();
        if (count != null) {
            day.setCount(((Long)this.convert(Long.class, count, (Object)0L)).longValue());
        }
        if (sum != null) {
            day.setSum(((Double)this.convert(Double.class, sum, (Object)0.0)).doubleValue());
        }
        if (avg != null) {
            day.setAvg(((Double)this.convert(Double.class, avg, (Object)0.0)).doubleValue());
        }
        return day;
    }

    public Domain buildDomain(Attributes attributes) {
        String id = attributes.getValue("id");
        Domain domain = new Domain(id);
        return domain;
    }

    public Entity buildEntity(Attributes attributes) {
        String id = attributes.getValue("id");
        Entity entity = new Entity(id);
        return entity;
    }

    public Machine buildMachine(Attributes attributes) {
        String ip = attributes.getValue("ip");
        Machine machine = new Machine(ip);
        return machine;
    }

    public Rush buildRush(Attributes attributes) {
        String count = attributes.getValue("count");
        String sum = attributes.getValue("sum");
        String avg = attributes.getValue("avg");
        Rush rush = new Rush();
        if (count != null) {
            rush.setCount(((Long)this.convert(Long.class, count, (Object)0L)).longValue());
        }
        if (sum != null) {
            rush.setSum(((Double)this.convert(Double.class, sum, (Object)0.0)).doubleValue());
        }
        if (avg != null) {
            rush.setAvg(((Double)this.convert(Double.class, avg, (Object)0.0)).doubleValue());
        }
        return rush;
    }

    public SystemReport buildSystemReport(Attributes attributes) {
        String startTime = attributes.getValue("startTime");
        String endTime = attributes.getValue("endTime");
        SystemReport systemReport = new SystemReport();
        if (startTime != null) {
            systemReport.setStartTime(this.toDate(startTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        if (endTime != null) {
            systemReport.setEndTime(this.toDate(endTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        return systemReport;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    protected Date toDate(String str, String format, Date defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }
}

