/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.system.transform;

import com.dianping.cat.home.system.IEntity;
import com.dianping.cat.home.system.entity.Day;
import com.dianping.cat.home.system.entity.Domain;
import com.dianping.cat.home.system.entity.Entity;
import com.dianping.cat.home.system.entity.Machine;
import com.dianping.cat.home.system.entity.Rush;
import com.dianping.cat.home.system.entity.SystemReport;
import com.dianping.cat.home.system.transform.DefaultLinker;
import com.dianping.cat.home.system.transform.DefaultSaxMaker;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static SystemReport parse(InputSource is) throws SAXException, IOException {
        return (SystemReport)DefaultSaxParser.parseEntity(SystemReport.class, (InputSource)is);
    }

    public static SystemReport parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(in));
    }

    public static SystemReport parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(reader));
    }

    public static SystemReport parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return (T)DefaultSaxParser.parseEntity(type, (InputSource)new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            this.m_objs.pop();
            this.m_tags.pop();
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForDay(Day parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForDomain(Domain parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"entity".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under domain!", qName));
        }
        Entity entity = this.m_maker.buildEntity(attributes);
        this.m_linker.onEntity(parentObj, entity);
        this.m_objs.push(entity);
        this.m_tags.push(qName);
    }

    private void parseForEntity(Entity parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("rush".equals(qName)) {
            Rush rush = this.m_maker.buildRush(attributes);
            this.m_linker.onRush(parentObj, rush);
            this.m_objs.push(rush);
        } else if ("day".equals(qName)) {
            Day day = this.m_maker.buildDay(attributes);
            this.m_linker.onDay(parentObj, day);
            this.m_objs.push(day);
        } else if ("machine".equals(qName)) {
            Machine machine = this.m_maker.buildMachine(attributes);
            this.m_linker.onMachine(parentObj, machine);
            this.m_objs.push(machine);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under entity!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForMachine(Machine parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForRush(Rush parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForSystemReport(SystemReport parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"domain".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under system-report!", qName));
        }
        Domain domain = this.m_maker.buildDomain(attributes);
        this.m_linker.onDomain(parentObj, domain);
        this.m_objs.push(domain);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("system-report".equals(qName)) {
            SystemReport systemReport = this.m_maker.buildSystemReport(attributes);
            this.m_entity = systemReport;
            this.m_objs.push(systemReport);
            this.m_tags.push(qName);
        } else if ("domain".equals(qName)) {
            Domain domain = this.m_maker.buildDomain(attributes);
            this.m_entity = domain;
            this.m_objs.push(domain);
            this.m_tags.push(qName);
        } else if ("entity".equals(qName)) {
            Entity entity = this.m_maker.buildEntity(attributes);
            this.m_entity = entity;
            this.m_objs.push(entity);
            this.m_tags.push(qName);
        } else if ("rush".equals(qName)) {
            Rush rush = this.m_maker.buildRush(attributes);
            this.m_entity = rush;
            this.m_objs.push(rush);
            this.m_tags.push(qName);
        } else if ("day".equals(qName)) {
            Day day = this.m_maker.buildDay(attributes);
            this.m_entity = day;
            this.m_objs.push(day);
            this.m_tags.push(qName);
        } else if ("machine".equals(qName)) {
            Machine machine = this.m_maker.buildMachine(attributes);
            this.m_entity = machine;
            this.m_objs.push(machine);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof SystemReport) {
                this.parseForSystemReport((SystemReport)parent, tag, qName, attributes);
            } else if (parent instanceof Domain) {
                this.parseForDomain((Domain)parent, tag, qName, attributes);
            } else if (parent instanceof Entity) {
                this.parseForEntity((Entity)parent, tag, qName, attributes);
            } else if (parent instanceof Rush) {
                this.parseForRush((Rush)parent, tag, qName, attributes);
            } else if (parent instanceof Day) {
                this.parseForDay((Day)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof Machine)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForMachine((Machine)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }

    protected Date toDate(String str, String format) {
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }
}

