/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.utilization.entity;

import com.dianping.cat.home.utilization.BaseEntity;
import com.dianping.cat.home.utilization.IVisitor;
import com.dianping.cat.home.utilization.entity.ApplicationState;
import com.dianping.cat.home.utilization.entity.MachineState;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain
extends BaseEntity<Domain> {
    private String m_id;
    private int m_machineNumber;
    private String m_cmdbId;
    private Map<String, MachineState> m_machineStates = new LinkedHashMap();
    private Map<String, ApplicationState> m_applicationStates = new LinkedHashMap();

    public Domain() {
    }

    public Domain(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitDomain(this);
    }

    public Domain addApplicationState(ApplicationState applicationState) {
        this.m_applicationStates.put(applicationState.getId(), applicationState);
        return this;
    }

    public Domain addMachineState(MachineState machineState) {
        this.m_machineStates.put(machineState.getId(), machineState);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Domain) {
            Domain _o = (Domain)obj;
            return this.equals((Object)this.m_id, (Object)_o.getId());
        }
        return false;
    }

    public ApplicationState findApplicationState(String id) {
        return (ApplicationState)this.m_applicationStates.get(id);
    }

    public MachineState findMachineState(String id) {
        return (MachineState)this.m_machineStates.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationState findOrCreateApplicationState(String id) {
        ApplicationState applicationState = (ApplicationState)this.m_applicationStates.get(id);
        if (applicationState == null) {
            Map map = this.m_applicationStates;
            synchronized (map) {
                applicationState = (ApplicationState)this.m_applicationStates.get(id);
                if (applicationState == null) {
                    applicationState = new ApplicationState(id);
                    this.m_applicationStates.put(id, applicationState);
                }
            }
        }
        return applicationState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineState findOrCreateMachineState(String id) {
        MachineState machineState = (MachineState)this.m_machineStates.get(id);
        if (machineState == null) {
            Map map = this.m_machineStates;
            synchronized (map) {
                machineState = (MachineState)this.m_machineStates.get(id);
                if (machineState == null) {
                    machineState = new MachineState(id);
                    this.m_machineStates.put(id, machineState);
                }
            }
        }
        return machineState;
    }

    public Map<String, ApplicationState> getApplicationStates() {
        return this.m_applicationStates;
    }

    public String getCmdbId() {
        return this.m_cmdbId;
    }

    public String getId() {
        return this.m_id;
    }

    public int getMachineNumber() {
        return this.m_machineNumber;
    }

    public Map<String, MachineState> getMachineStates() {
        return this.m_machineStates;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(Domain other) {
        this.assertAttributeEquals((Object)other, "domain", "id", (Object)this.m_id, (Object)other.getId());
        this.m_machineNumber = other.getMachineNumber();
        if (other.getCmdbId() != null) {
            this.m_cmdbId = other.getCmdbId();
        }
    }

    public ApplicationState removeApplicationState(String id) {
        return (ApplicationState)this.m_applicationStates.remove(id);
    }

    public MachineState removeMachineState(String id) {
        return (MachineState)this.m_machineStates.remove(id);
    }

    public Domain setCmdbId(String cmdbId) {
        this.m_cmdbId = cmdbId;
        return this;
    }

    public Domain setId(String id) {
        this.m_id = id;
        return this;
    }

    public Domain setMachineNumber(int machineNumber) {
        this.m_machineNumber = machineNumber;
        return this;
    }
}

