/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.utilization.transform;

import com.dianping.cat.home.utilization.IEntity;
import com.dianping.cat.home.utilization.IVisitor;
import com.dianping.cat.home.utilization.entity.ApplicationState;
import com.dianping.cat.home.utilization.entity.Domain;
import com.dianping.cat.home.utilization.entity.MachineState;
import com.dianping.cat.home.utilization.entity.UtilizationReport;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private UtilizationReport m_utilizationReport;

    public DefaultMerger() {
    }

    public DefaultMerger(UtilizationReport utilizationReport) {
        this.m_utilizationReport = utilizationReport;
        this.m_objs.push(utilizationReport);
    }

    public UtilizationReport getUtilizationReport() {
        return this.m_utilizationReport;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept((IVisitor)this);
        this.m_objs.pop();
    }

    protected void mergeApplicationState(ApplicationState to, ApplicationState from) {
        to.mergeAttributes(from);
    }

    protected void mergeDomain(Domain to, Domain from) {
        to.mergeAttributes(from);
    }

    protected void mergeMachineState(MachineState to, MachineState from) {
        to.mergeAttributes(from);
    }

    protected void mergeUtilizationReport(UtilizationReport to, UtilizationReport from) {
        to.mergeAttributes(from);
    }

    public void visitApplicationState(ApplicationState from) {
        ApplicationState to = (ApplicationState)this.m_objs.peek();
        this.mergeApplicationState(to, from);
        this.visitApplicationStateChildren(to, from);
    }

    protected void visitApplicationStateChildren(ApplicationState to, ApplicationState from) {
    }

    public void visitDomain(Domain from) {
        Domain to = (Domain)this.m_objs.peek();
        this.mergeDomain(to, from);
        this.visitDomainChildren(to, from);
    }

    protected void visitDomainChildren(Domain to, Domain from) {
        MachineState target;
        for (MachineState source : from.getMachineStates().values()) {
            target = to.findMachineState(source.getId());
            if (target == null) {
                target = new MachineState(source.getId());
                to.addMachineState(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
        for (MachineState source : from.getApplicationStates().values()) {
            target = to.findApplicationState(source.getId());
            if (target == null) {
                target = new ApplicationState(source.getId());
                to.addApplicationState((ApplicationState)target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitMachineState(MachineState from) {
        MachineState to = (MachineState)this.m_objs.peek();
        this.mergeMachineState(to, from);
        this.visitMachineStateChildren(to, from);
    }

    protected void visitMachineStateChildren(MachineState to, MachineState from) {
    }

    public void visitUtilizationReport(UtilizationReport from) {
        UtilizationReport to = (UtilizationReport)this.m_objs.peek();
        this.mergeUtilizationReport(to, from);
        this.visitUtilizationReportChildren(to, from);
    }

    protected void visitUtilizationReportChildren(UtilizationReport to, UtilizationReport from) {
        for (Domain source : from.getDomains().values()) {
            Domain target = to.findDomain(source.getId());
            if (target == null) {
                target = new Domain(source.getId());
                to.addDomain(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }
}

