/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.utilization.transform;

import com.dianping.cat.home.utilization.IVisitor;
import com.dianping.cat.home.utilization.entity.ApplicationState;
import com.dianping.cat.home.utilization.entity.Domain;
import com.dianping.cat.home.utilization.entity.MachineState;
import com.dianping.cat.home.utilization.entity.UtilizationReport;
import com.dianping.cat.home.utilization.transform.DefaultLinker;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeParser
implements IVisitor {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DataInputStream m_in;

    public DefaultNativeParser(InputStream in) {
        this.m_in = new DataInputStream(in);
    }

    public static UtilizationReport parse(byte[] data) {
        return DefaultNativeParser.parse((InputStream)new ByteArrayInputStream(data));
    }

    public static UtilizationReport parse(InputStream in) {
        UtilizationReport utilizationReport;
        DefaultNativeParser parser;
        block2: {
            parser = new DefaultNativeParser(in);
            utilizationReport = new UtilizationReport();
            try {
                utilizationReport.accept((IVisitor)parser);
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof EOFException) break block2;
                throw e;
            }
        }
        parser.m_linker.finish();
        return utilizationReport;
    }

    public void visitApplicationState(ApplicationState applicationState) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitApplicationStateChildren(applicationState, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitApplicationStateChildren(ApplicationState applicationState, int _field, int _type) {
        switch (_field) {
            case 1: {
                applicationState.setId(this.readString());
                break;
            }
            case 2: {
                applicationState.setFailureCount(this.readLong());
                break;
            }
            case 3: {
                applicationState.setFailurePercent(this.readDouble());
                break;
            }
            case 4: {
                applicationState.setCount(this.readLong());
                break;
            }
            case 5: {
                applicationState.setMaxQps(this.readDouble());
                break;
            }
            case 6: {
                applicationState.setAvg(this.readDouble());
                break;
            }
            case 7: {
                applicationState.setSum(this.readDouble());
                break;
            }
            case 8: {
                applicationState.setAvg95(this.readDouble());
            }
        }
    }

    public void visitDomain(Domain domain) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitDomainChildren(domain, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitDomainChildren(Domain domain, int _field, int _type) {
        switch (_field) {
            case 1: {
                domain.setId(this.readString());
                break;
            }
            case 2: {
                domain.setMachineNumber(this.readInt());
                break;
            }
            case 3: {
                domain.setCmdbId(this.readString());
                break;
            }
            case 33: {
                if (_type == 1) {
                    MachineState machineStates = new MachineState();
                    this.visitMachineState(machineStates);
                    this.m_linker.onMachineState(domain, machineStates);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    MachineState machineStates = new MachineState();
                    this.visitMachineState(machineStates);
                    this.m_linker.onMachineState(domain, machineStates);
                }
                break;
            }
            case 34: {
                if (_type == 1) {
                    ApplicationState applicationStates = new ApplicationState();
                    this.visitApplicationState(applicationStates);
                    this.m_linker.onApplicationState(domain, applicationStates);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    ApplicationState applicationStates = new ApplicationState();
                    this.visitApplicationState(applicationStates);
                    this.m_linker.onApplicationState(domain, applicationStates);
                }
                break;
            }
        }
    }

    public void visitMachineState(MachineState machineState) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitMachineStateChildren(machineState, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitMachineStateChildren(MachineState machineState, int _field, int _type) {
        switch (_field) {
            case 1: {
                machineState.setId(this.readString());
                break;
            }
            case 2: {
                machineState.setCount(this.readLong());
                break;
            }
            case 3: {
                machineState.setSum(this.readDouble());
                break;
            }
            case 4: {
                machineState.setAvg(this.readDouble());
                break;
            }
            case 5: {
                machineState.setAvgMax(this.readDouble());
            }
        }
    }

    public void visitUtilizationReport(UtilizationReport utilizationReport) {
        byte tag = this.readTag();
        if (tag != -4) {
            throw new RuntimeException(String.format("Malformed payload, expected: %s, but was: %s!", -4, tag));
        }
        while ((tag = this.readTag()) != -1) {
            this.visitUtilizationReportChildren(utilizationReport, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitUtilizationReportChildren(UtilizationReport utilizationReport, int _field, int _type) {
        switch (_field) {
            case 1: {
                utilizationReport.setDomain(this.readString());
                break;
            }
            case 2: {
                utilizationReport.setStartTime(this.readDate());
                break;
            }
            case 3: {
                utilizationReport.setEndTime(this.readDate());
                break;
            }
            case 33: {
                if (_type == 1) {
                    Domain domains = new Domain();
                    this.visitDomain(domains);
                    this.m_linker.onDomain(utilizationReport, domains);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Domain domains = new Domain();
                    this.visitDomain(domains);
                    this.m_linker.onDomain(utilizationReport, domains);
                }
                break;
            }
        }
    }

    private Date readDate() {
        try {
            return new Date(this.readVarint(64));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private double readDouble() {
        try {
            return Double.longBitsToDouble(this.readVarint(64));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int readInt() {
        try {
            return (int)this.readVarint(32);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private long readLong() {
        try {
            return this.readVarint(64);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readString() {
        try {
            return this.m_in.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte readTag() {
        try {
            return this.m_in.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected long readVarint(int length) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < length; shift += 7) {
            byte b = this.m_in.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new RuntimeException("Malformed variable int " + length + "!");
    }
}

