/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.utilization.transform;

import com.dianping.cat.home.utilization.entity.ApplicationState;
import com.dianping.cat.home.utilization.entity.Domain;
import com.dianping.cat.home.utilization.entity.MachineState;
import com.dianping.cat.home.utilization.entity.UtilizationReport;
import com.dianping.cat.home.utilization.transform.IMaker;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSaxMaker
implements IMaker<Attributes> {
    public ApplicationState buildApplicationState(Attributes attributes) {
        String id = attributes.getValue("id");
        String failureCount = attributes.getValue("failure-count");
        String failurePercent = attributes.getValue("failure-percent");
        String count = attributes.getValue("count");
        String maxQps = attributes.getValue("maxQps");
        String avg = attributes.getValue("avg");
        String sum = attributes.getValue("sum");
        String avg95 = attributes.getValue("avg95");
        ApplicationState applicationState = new ApplicationState(id);
        if (failureCount != null) {
            applicationState.setFailureCount(((Long)this.convert(Long.class, failureCount, (Object)0L)).longValue());
        }
        if (failurePercent != null) {
            applicationState.setFailurePercent(this.toNumber(failurePercent, "0.000000", (Number)0).doubleValue());
        }
        if (count != null) {
            applicationState.setCount(((Long)this.convert(Long.class, count, (Object)0L)).longValue());
        }
        if (maxQps != null) {
            applicationState.setMaxQps(this.toNumber(maxQps, "0.0000", (Number)0).doubleValue());
        }
        if (avg != null) {
            applicationState.setAvg(this.toNumber(avg, "0.0000", (Number)0).doubleValue());
        }
        if (sum != null) {
            applicationState.setSum(this.toNumber(sum, "0.0000", (Number)0).doubleValue());
        }
        if (avg95 != null) {
            applicationState.setAvg95(this.toNumber(avg95, "0.0000", (Number)0).doubleValue());
        }
        return applicationState;
    }

    public Domain buildDomain(Attributes attributes) {
        String id = attributes.getValue("id");
        String machineNumber = attributes.getValue("machine-number");
        String cmdbId = attributes.getValue("cmdb-id");
        Domain domain = new Domain(id);
        if (machineNumber != null) {
            domain.setMachineNumber(((Integer)this.convert(Integer.class, machineNumber, (Object)0)).intValue());
        }
        if (cmdbId != null) {
            domain.setCmdbId(cmdbId);
        }
        return domain;
    }

    public MachineState buildMachineState(Attributes attributes) {
        String id = attributes.getValue("id");
        String count = attributes.getValue("count");
        String sum = attributes.getValue("sum");
        String avg = attributes.getValue("avg");
        String avgMax = attributes.getValue("avg-max");
        MachineState machineState = new MachineState(id);
        if (count != null) {
            machineState.setCount(((Long)this.convert(Long.class, count, (Object)0L)).longValue());
        }
        if (sum != null) {
            machineState.setSum(this.toNumber(sum, "0.0000", (Number)0).doubleValue());
        }
        if (avg != null) {
            machineState.setAvg(this.toNumber(avg, "0.0000", (Number)0).doubleValue());
        }
        if (avgMax != null) {
            machineState.setAvgMax(this.toNumber(avgMax, "0.0000", (Number)0).doubleValue());
        }
        return machineState;
    }

    public UtilizationReport buildUtilizationReport(Attributes attributes) {
        String domain = attributes.getValue("domain");
        String startTime = attributes.getValue("startTime");
        String endTime = attributes.getValue("endTime");
        UtilizationReport utilizationReport = new UtilizationReport(domain);
        if (startTime != null) {
            utilizationReport.setStartTime(this.toDate(startTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        if (endTime != null) {
            utilizationReport.setEndTime(this.toDate(endTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        return utilizationReport;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    protected Date toDate(String str, String format, Date defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }

    protected Number toNumber(String str, String format, Number defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            return new DecimalFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse number(%s) in format(%s)!", str, format), e);
        }
    }
}

