/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.company.model.entity.ProductLine;
import com.dianping.cat.consumer.config.ProductLineConfigManager;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.alert.AlarmRule;
import com.dianping.cat.report.alert.AlertInfo;
import com.dianping.cat.report.alert.AlertResultEntity;
import com.dianping.cat.report.alert.DataChecker;
import com.dianping.cat.report.alert.MetricReportGroup;
import com.dianping.cat.report.alert.MetricReportGroupService;
import com.dianping.cat.report.alert.MetricType;
import com.dianping.cat.report.alert.config.BaseRuleConfigManager;
import com.dianping.cat.report.alert.sender.AlertEntity;
import com.dianping.cat.report.alert.sender.AlertManager;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseAlert
implements Threads.Task,
LogEnabled {
    @Inject
    protected AlertInfo m_alertInfo;
    @Inject
    protected DataChecker m_dataChecker;
    @Inject
    protected ProductLineConfigManager m_productLineConfigManager;
    @Inject
    protected MetricReportGroupService m_service;
    @Inject
    protected AlertManager m_sendManager;
    private static final int DATA_AREADY_MINUTE = 1;
    protected static final long DURATION = 60000L;
    protected Logger m_logger;

    protected int calAlreadyMinute() {
        long current = System.currentTimeMillis() / 1000L / 60L;
        int minute = (int)(current % 60L) - 1;
        return minute;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    protected abstract Map<String, ProductLine> getProductlines();

    protected abstract BaseRuleConfigManager getRuleConfigManager();

    protected double[] mergerArray(double[] from, double[] to) {
        int i;
        int fromLength = from.length;
        int toLength = to.length;
        double[] result = new double[fromLength + toLength];
        int index = 0;
        for (i = 0; i < fromLength; ++i) {
            result[i] = from[i];
            ++index;
        }
        for (i = 0; i < toLength; ++i) {
            result[i + index] = to[i];
        }
        return result;
    }

    protected String parseMetricId(String metricKey) {
        try {
            String[] items = metricKey.split(":");
            if (items.length >= 3) {
                return items[2];
            }
            Cat.logEvent((String)"ErrorMetricName", (String)metricKey, (String)"0", null);
            return null;
        }
        catch (Exception ex) {
            Cat.logError((String)("extract metric name error:" + metricKey), (Throwable)ex);
            return null;
        }
    }

    protected void processProductLine(ProductLine productLine) {
        int minute = this.calAlreadyMinute();
        String product = productLine.getId();
        AlarmRule alarmRule = this.getRuleConfigManager().queryConfigs(product);
        int nowMinute = this.calAlreadyMinute();
        int maxRuleMinute = alarmRule.calMaxRuleMinute();
        if (maxRuleMinute > 0) {
            MetricReportGroup reports = this.m_service.prepareDatas(product, nowMinute, maxRuleMinute);
            if (reports.isDataReady()) {
                for (Map.Entry metricItem : reports.getMetricItem().entrySet()) {
                    try {
                        String metricKey = (String)metricItem.getKey();
                        String metricName = this.parseMetricId(metricKey);
                        List detailRules = alarmRule.findDetailRules(metricName);
                        for (Map rule : detailRules) {
                            for (Map.Entry entry : rule.entrySet()) {
                                List conditions;
                                MetricType dateType;
                                int ruleMinute;
                                double[] value;
                                List results;
                                Pair conditionPair = this.getRuleConfigManager().convertConditions((List)entry.getValue());
                                if (conditionPair == null || (results = this.m_dataChecker.checkData(value = reports.extractData(minute, ruleMinute = ((Integer)conditionPair.getKey()).intValue(), metricKey, dateType = (MetricType)entry.getKey()), conditions = (List)conditionPair.getValue())).size() <= 0) continue;
                                this.updateAlertStatus(product, metricKey);
                                this.sendAlerts(product, metricName, results);
                            }
                        }
                    }
                    catch (Exception e) {
                        Cat.logError((Throwable)e);
                    }
                }
            } else {
                Cat.logEvent((String)"AlertDataNotFount", (String)this.getName(), (String)"0", null);
            }
        } else {
            Cat.logEvent((String)("NoAlarmRule:" + this.getName()), (String)product, (String)"0", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean active = TimeHelper.sleepToNextMinute();
        while (active) {
            try {
                Transaction t = Cat.newTransaction((String)("Alert" + this.getName()), (String)TimeHelper.getMinuteStr());
                long current = System.currentTimeMillis();
                try {
                    Map productLines = this.getProductlines();
                    for (ProductLine productLine : productLines.values()) {
                        try {
                            this.processProductLine(productLine);
                        }
                        catch (Exception e) {
                            Cat.logError((Throwable)e);
                        }
                    }
                    t.setStatus("0");
                }
                catch (Throwable e) {
                    t.setStatus(e);
                }
                finally {
                    t.complete();
                }
                long duration = System.currentTimeMillis() - current;
                try {
                    if (duration >= 60000L) continue;
                    Thread.sleep(60000L - duration);
                }
                catch (InterruptedException e) {
                    active = false;
                }
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
    }

    protected void sendAlerts(String productlineName, String metricName, List<AlertResultEntity> alertResults) {
        for (AlertResultEntity alertResult : alertResults) {
            AlertEntity entity = new AlertEntity();
            entity.setDate(alertResult.getAlertTime()).setContent(alertResult.getContent()).setLevel(alertResult.getAlertLevel());
            entity.setMetric(metricName).setType(this.getName()).setGroup(productlineName);
            this.m_sendManager.addAlert(entity);
        }
    }

    public void shutdown() {
    }

    protected void updateAlertStatus(String productlineName, String metricKey) {
        this.m_alertInfo.addAlertInfo(productlineName, metricKey, new Date().getTime());
    }
}

