/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert;

import com.dianping.cat.Cat;
import com.dianping.cat.home.rule.entity.Condition;
import com.dianping.cat.home.rule.entity.SubCondition;
import com.dianping.cat.report.alert.AlertResultEntity;
import com.dianping.cat.report.alert.DataChecker;
import com.dianping.cat.report.alert.RuleType;
import java.util.ArrayList;
import java.util.List;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDataChecker
implements DataChecker {
    private double[] buildLastMinutesDoubleArray(double[] doubleList, int remainCount) {
        if (doubleList.length <= remainCount) {
            return doubleList;
        }
        double[] result = new double[remainCount];
        int startIndex = doubleList.length - remainCount;
        for (int i = 0; i < remainCount; ++i) {
            result[i] = doubleList[startIndex + i];
        }
        return result;
    }

    public List<AlertResultEntity> checkData(double[] value, double[] baseline, List<Condition> conditions) {
        ArrayList<AlertResultEntity> alertResults = new ArrayList<AlertResultEntity>();
        for (Condition condition : conditions) {
            double[] baselineValid;
            int conditionMinute = condition.getMinute();
            double[] valueValid = this.buildLastMinutesDoubleArray(value, conditionMinute);
            Pair condResult = this.checkDataByCondition(valueValid, baselineValid = this.buildLastMinutesDoubleArray(baseline, conditionMinute), condition);
            if (!((Boolean)condResult.getKey()).booleanValue()) continue;
            String alertType = condition.getAlertType();
            alertResults.add(new AlertResultEntity(((Boolean)condResult.getKey()).booleanValue(), (String)condResult.getValue(), alertType));
        }
        return alertResults;
    }

    public List<AlertResultEntity> checkData(double[] value, List<Condition> conditions) {
        ArrayList<AlertResultEntity> alertResults = new ArrayList<AlertResultEntity>();
        for (Condition condition : conditions) {
            int conditionMinute = condition.getMinute();
            double[] valueValid = this.buildLastMinutesDoubleArray(value, conditionMinute);
            Pair condResult = this.checkDataByCondition(valueValid, valueValid, condition);
            if (!((Boolean)condResult.getKey()).booleanValue()) continue;
            String alertType = condition.getAlertType();
            alertResults.add(new AlertResultEntity(((Boolean)condResult.getKey()).booleanValue(), (String)condResult.getValue(), alertType));
        }
        return alertResults;
    }

    private Pair<Boolean, String> checkDataByCondition(double[] value, double[] baseline, Condition condition) {
        StringBuilder builder = new StringBuilder();
        for (SubCondition subCondition : condition.getSubConditions()) {
            try {
                String ruleType = subCondition.getType();
                RuleType rule = RuleType.getByTypeId((String)ruleType);
                Pair subResult = rule.executeRule(value, baseline, subCondition.getText());
                if (!((Boolean)subResult.getKey()).booleanValue()) {
                    return new Pair((Object)false, (Object)"");
                }
                builder.append((String)subResult.getValue()).append("<br/>");
            }
            catch (Exception ex) {
                Cat.logError((String)condition.toString(), (Throwable)ex);
                return new Pair((Object)false, (Object)"");
            }
        }
        return new Pair((Object)true, (Object)builder.toString());
    }

    public List<AlertResultEntity> checkDataForApp(double[] value, List<Condition> conditions) {
        ArrayList<AlertResultEntity> alertResults = new ArrayList<AlertResultEntity>();
        for (Condition condition : conditions) {
            int conditionMinute = condition.getMinute() / 5;
            double[] valueValid = this.buildLastMinutesDoubleArray(value, conditionMinute);
            Pair condResult = this.checkDataByCondition(valueValid, valueValid, condition);
            if (!((Boolean)condResult.getKey()).booleanValue()) continue;
            String alertType = condition.getAlertType();
            alertResults.add(new AlertResultEntity(((Boolean)condResult.getKey()).booleanValue(), (String)condResult.getValue(), alertType));
        }
        return alertResults;
    }
}

