/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert;

import com.dianping.cat.consumer.metric.model.entity.MetricItem;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.consumer.metric.model.entity.Segment;
import com.dianping.cat.report.alert.MetricReportGroup;
import com.dianping.cat.report.alert.MetricType;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricReportGroup {
    private MetricReport m_last;
    private MetricReport m_current;
    private State m_type;
    private boolean m_dataReady;

    public double[] extractData(int currentMinute, int ruleMinute, String metricKey, MetricType type) {
        double[] value = new double[ruleMinute];
        if (currentMinute >= ruleMinute - 1) {
            int start = currentMinute + 1 - ruleMinute;
            int end = currentMinute;
            value = this.queryRealData(start, end, metricKey, this.m_current, type);
        } else if (currentMinute < 0) {
            int start = 60 + currentMinute + 1 - ruleMinute;
            int end = 60 + currentMinute;
            value = this.queryRealData(start, end, metricKey, this.m_last, type);
        } else {
            int currentStart = 0;
            int currentEnd = currentMinute;
            double[] currentValue = this.queryRealData(currentStart, currentEnd, metricKey, this.m_current, type);
            int lastStart = 61 - (ruleMinute - currentMinute);
            int lastEnd = 59;
            double[] lastValue = this.queryRealData(lastStart, lastEnd, metricKey, this.m_last, type);
            value = this.mergerArray(lastValue, currentValue);
        }
        return value;
    }

    public MetricReport getCurrent() {
        return this.m_current;
    }

    public MetricReport getLast() {
        return this.m_last;
    }

    public Map<String, MetricItem> getMetricItem() {
        if (this.m_type == State.LAST) {
            return this.m_last.getMetricItems();
        }
        return this.m_current.getMetricItems();
    }

    public State getType() {
        return this.m_type;
    }

    public boolean isDataReady() {
        return this.m_dataReady;
    }

    public double[] mergerArray(double[] from, double[] to) {
        int i;
        int fromLength = from.length;
        int toLength = to.length;
        double[] result = new double[fromLength + toLength];
        int index = 0;
        for (i = 0; i < fromLength; ++i) {
            result[i] = from[i];
            ++index;
        }
        for (i = 0; i < toLength; ++i) {
            result[i + index] = to[i];
        }
        return result;
    }

    private double[] queryRealData(int start, int end, String metricKey, MetricReport report, MetricType type) {
        double[] all = new double[60];
        Map map = report.findOrCreateMetricItem(metricKey).getSegments();
        for (Map.Entry entry : map.entrySet()) {
            Integer minute = (Integer)entry.getKey();
            Segment seg = (Segment)entry.getValue();
            if (type == MetricType.AVG) {
                all[minute.intValue()] = seg.getAvg();
                continue;
            }
            if (type == MetricType.COUNT) {
                all[minute.intValue()] = seg.getCount();
                continue;
            }
            if (type != MetricType.SUM) continue;
            all[minute.intValue()] = seg.getSum();
        }
        int length = end - start + 1;
        double[] result = new double[length];
        System.arraycopy(all, start, result, 0, length);
        return result;
    }

    public MetricReportGroup setCurrent(MetricReport current) {
        this.m_current = current;
        return this;
    }

    public void setDataReady(boolean dataReady) {
        this.m_dataReady = dataReady;
    }

    public MetricReportGroup setLast(MetricReport last) {
        this.m_last = last;
        return this;
    }

    public MetricReportGroup setType(State type) {
        this.m_type = type;
        return this;
    }
}

