/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert;

import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.report.alert.MetricReportGroup;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import org.unidal.lookup.annotation.Inject;

public class MetricReportGroupService {
    @Inject
    private ModelService<MetricReport> m_service;

    private MetricReport fetchMetricReport(String product, ModelPeriod period, int min, int max) {
        ModelRequest request = new ModelRequest(product, period.getStartTime()).setProperty("requireAll", "ture");
        request.setProperty("min", String.valueOf(min));
        request.setProperty("max", String.valueOf(max));
        ModelResponse response = this.m_service.invoke(request);
        if (response != null) {
            return (MetricReport)response.getModel();
        }
        return null;
    }

    public MetricReport fetchMetricReport(ModelRequest request) {
        request.setProperty("requireAll", "ture");
        ModelResponse response = this.m_service.invoke(request);
        if (response != null) {
            return (MetricReport)response.getModel();
        }
        return null;
    }

    public MetricReportGroup prepareDatas(String product, int minute, int duration) {
        int min;
        MetricReport currentReport = null;
        MetricReport lastReport = null;
        boolean dataReady = false;
        MetricReportGroup.State type = null;
        if (minute >= duration - 1) {
            min = minute - duration + 1;
            int max = minute;
            type = MetricReportGroup.State.CURRENT;
            currentReport = this.fetchMetricReport(product, ModelPeriod.CURRENT, min, max);
            if (currentReport != null) {
                dataReady = true;
            }
        } else if (minute < 0) {
            min = minute + 60 - duration + 1;
            int max = minute + 60;
            type = MetricReportGroup.State.LAST;
            lastReport = this.fetchMetricReport(product, ModelPeriod.LAST, min, max);
            if (lastReport != null) {
                dataReady = true;
            }
        } else {
            int lastLength = duration - minute - 1;
            int lastMin = 60 - lastLength;
            type = MetricReportGroup.State.CURRENT_LAST;
            currentReport = this.fetchMetricReport(product, ModelPeriod.CURRENT, 0, minute);
            lastReport = this.fetchMetricReport(product, ModelPeriod.LAST, lastMin, 59);
            if (lastReport != null && currentReport != null) {
                dataReady = true;
            }
        }
        MetricReportGroup reports = new MetricReportGroup();
        reports.setType(type).setLast(lastReport).setCurrent(currentReport).setDataReady(dataReady);
        return reports;
    }
}

