/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert;

import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public enum RuleType {
    DecreasePercentage/* Unavailable Anonymous Inner Class!! */,
    DecreaseValue/* Unavailable Anonymous Inner Class!! */,
    IncreasePercentage/* Unavailable Anonymous Inner Class!! */,
    IncreaseValue/* Unavailable Anonymous Inner Class!! */,
    AbsoluteMaxValue/* Unavailable Anonymous Inner Class!! */,
    AbsoluteMinValue/* Unavailable Anonymous Inner Class!! */,
    FluctuateIncreasePercentage/* Unavailable Anonymous Inner Class!! */,
    FluctuateDecreasePercentage/* Unavailable Anonymous Inner Class!! */,
    SumMaxValue/* Unavailable Anonymous Inner Class!! */,
    SumMinValue/* Unavailable Anonymous Inner Class!! */,
    UserDefine/* Unavailable Anonymous Inner Class!! */;

    static Map<String, RuleType> s_map;
    protected static final long MbS = 0x780000L;
    protected static final long GbS = 0x1E0000000L;
    protected DecimalFormat m_df = new DecimalFormat("0.###");

    public static RuleType getByTypeId(String typeId) {
        return (RuleType)s_map.get(typeId);
    }

    protected abstract String buildRuleMessage(double[] var1, double[] var2, double var3);

    protected double calSum(double[] values) {
        double totalVal = 0.0;
        for (double value : values) {
            totalVal += value;
        }
        return totalVal;
    }

    protected String convertDoublesToString(double[] values) {
        StringBuilder builder = new StringBuilder();
        for (double value : values) {
            builder.append(this.convertDoubleToString(value)).append(" ");
        }
        return builder.toString();
    }

    protected String convertDoubleToString(double value) {
        if (value < 7864320.0) {
            return this.m_df.format(value);
        }
        if (value < 8.05306368E9) {
            return this.m_df.format(value / 7864320.0) + "Mb/s";
        }
        return this.m_df.format(value / 8.05306368E9) + "Gb/s";
    }

    protected String convertPercentsToString(double[] values) {
        StringBuilder builder = new StringBuilder();
        for (double value : values) {
            builder.append(this.m_df.format(value)).append("% ");
        }
        return builder.toString();
    }

    public abstract Pair<Boolean, String> executeRule(double[] var1, double[] var2, String var3);

    public abstract String getId();

    protected double parseStringToDouble(String text) {
        if (text.endsWith("Mb/s")) {
            double value = Double.parseDouble(text.replaceAll("Mb/s", ""));
            return value * 60.0 * 1024.0 * 1024.0 / 8.0;
        }
        if (text.endsWith("Gb/s")) {
            double value = Double.parseDouble(text.replaceAll("Gb/s", ""));
            return value * 60.0 * 1024.0 * 1024.0 * 1024.0 / 8.0;
        }
        if (text.endsWith("MB/s")) {
            double value = Double.parseDouble(text.replaceAll("MB/s", ""));
            return value * 60.0 * 1024.0 * 1024.0;
        }
        if (text.endsWith("GB/s")) {
            double value = Double.parseDouble(text.replaceAll("GB/s", ""));
            return value * 60.0 * 1024.0 * 1024.0 * 1024.0;
        }
        if (text.endsWith("Mb")) {
            double value = Double.parseDouble(text.replaceAll("Mb", ""));
            return value * 1024.0 * 1024.0 / 8.0;
        }
        if (text.endsWith("Gb")) {
            double value = Double.parseDouble(text.replaceAll("Gb", ""));
            return value * 1024.0 * 1024.0 * 1024.0 / 8.0;
        }
        if (text.endsWith("MB")) {
            double value = Double.parseDouble(text.replaceAll("MB", ""));
            return value * 1024.0 * 1024.0;
        }
        if (text.endsWith("GB")) {
            double value = Double.parseDouble(text.replaceAll("GB", ""));
            return value * 1024.0 * 1024.0 * 1024.0;
        }
        return Double.parseDouble(text);
    }

    static {
        s_map = new LinkedHashMap();
        for (RuleType type : RuleType.values()) {
            s_map.put(type.getId(), type);
        }
    }
}

