/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.app;

import com.dianping.cat.Cat;
import com.dianping.cat.config.app.AppConfigManager;
import com.dianping.cat.configuration.app.entity.Command;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.home.rule.entity.Condition;
import com.dianping.cat.home.rule.entity.Config;
import com.dianping.cat.home.rule.entity.MonitorRules;
import com.dianping.cat.home.rule.entity.Rule;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.alert.AlertResultEntity;
import com.dianping.cat.report.alert.AlertType;
import com.dianping.cat.report.alert.DataChecker;
import com.dianping.cat.report.alert.app.AppRuleConfigManager;
import com.dianping.cat.report.alert.sender.AlertEntity;
import com.dianping.cat.report.alert.sender.AlertManager;
import com.dianping.cat.report.page.app.service.AppDataService;
import com.dianping.cat.report.page.app.service.CommandQueryEntity;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppAlert
implements Threads.Task {
    @Inject
    private AppDataService m_appDataService;
    @Inject
    private AlertManager m_sendManager;
    @Inject
    private AppRuleConfigManager m_appRuleConfigManager;
    @Inject
    private DataChecker m_dataChecker;
    @Inject
    private AppConfigManager m_appConfigManager;
    private static final long DURATION = 300000L;
    private static final int DATA_AREADY_MINUTE = 10;
    private SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy-MM-dd");

    private Long buildMillsByString(String time) throws Exception {
        String[] times = time.split(":");
        int hour = Integer.parseInt(times[0]);
        int minute = Integer.parseInt(times[1]);
        long result = hour * 60 * 60 * 1000 + minute * 60 * 1000;
        return result;
    }

    private double[] fetchDatas(String conditions, String type, int minute) {
        long time = System.currentTimeMillis() / 1000L / 60L;
        int endMinute = (int)(time % 60L) - 10;
        int startMinute = endMinute - minute;
        double[] datas = null;
        if (startMinute < 0 && endMinute < 0) {
            String period = this.m_sdf.format(this.queryDayPeriod(-1).getTime());
            CommandQueryEntity queryEntity = new CommandQueryEntity(period + ";" + conditions + ";;");
            datas = ArrayUtils.toPrimitive((Double[])this.m_appDataService.queryValue(queryEntity, type), (double)0.0);
        } else if (startMinute < 0 && endMinute >= 0) {
            String last = this.m_sdf.format(this.queryDayPeriod(-1).getTime());
            String current = this.m_sdf.format(this.queryDayPeriod(0).getTime());
            CommandQueryEntity lastQueryEntity = new CommandQueryEntity(last + ";" + conditions + ";;");
            CommandQueryEntity currentQueryEntity = new CommandQueryEntity(current + ";" + conditions + ";;");
            double[] lastDatas = ArrayUtils.toPrimitive((Double[])this.m_appDataService.queryValue(lastQueryEntity, type), (double)0.0);
            double[] currentDatas = ArrayUtils.toPrimitive((Double[])this.m_appDataService.queryValue(currentQueryEntity, type), (double)0.0);
            datas = this.mergerArray(lastDatas, currentDatas);
        } else if (startMinute >= 0) {
            String period = this.m_sdf.format(this.queryDayPeriod(0).getTime());
            CommandQueryEntity queryEntity = new CommandQueryEntity(period + ";" + conditions + ";;");
            datas = ArrayUtils.toPrimitive((Double[])this.m_appDataService.queryValue(queryEntity, type), (double)0.0);
        }
        return datas;
    }

    public String getName() {
        return AlertType.App.getName();
    }

    private boolean judgeCurrentInConfigRange(Config config) {
        long ruleEndTime;
        long ruleStartTime;
        Calendar cal = Calendar.getInstance();
        int hour = cal.get(11);
        int minute = cal.get(12);
        int nowTime = hour * 60 * 60 * 1000 + minute * 60 * 1000;
        try {
            ruleStartTime = this.buildMillsByString(config.getStarttime());
            ruleEndTime = this.buildMillsByString(config.getEndtime());
        }
        catch (Exception ex) {
            ruleStartTime = 0L;
            ruleEndTime = 86400000L;
        }
        return (long)nowTime >= ruleStartTime && (long)nowTime <= ruleEndTime;
    }

    protected double[] mergerArray(double[] from, double[] to) {
        int i;
        int fromLength = from.length;
        int toLength = to.length;
        double[] result = new double[fromLength + toLength];
        int index = 0;
        for (i = 0; i < fromLength; ++i) {
            result[i] = from[i];
            ++index;
        }
        for (i = 0; i < toLength; ++i) {
            result[i + index] = to[i];
        }
        return result;
    }

    private void processRule(Rule rule) {
        String id = rule.getId();
        int index1 = id.indexOf(":");
        int index2 = id.indexOf(":", index1 + 1);
        String conditions = id.substring(0, index1);
        String type = id.substring(index1 + 1, index2);
        String name = id.substring(index2 + 1);
        int command = Integer.valueOf(conditions.split(";")[0]);
        Pair pair = this.queryCheckMinuteAndConditions(rule.getConfigs());
        double[] datas = this.fetchDatas(conditions, type, ((Integer)pair.getKey()).intValue());
        if (datas != null && datas.length > 0) {
            List checkedConditions = (List)pair.getValue();
            List alertResults = this.m_dataChecker.checkDataForApp(datas, checkedConditions);
            String commandName = this.queryCommand(command);
            String typeStr = this.queryType(type);
            for (AlertResultEntity alertResult : alertResults) {
                HashMap<String, String> par = new HashMap<String, String>();
                par.put("name", name);
                AlertEntity entity = new AlertEntity();
                entity.setDate(alertResult.getAlertTime()).setContent(alertResult.getContent()).setLevel(alertResult.getAlertLevel());
                entity.setMetric(typeStr).setType(this.getName()).setGroup(commandName).setParas(par);
                this.m_sendManager.addAlert(entity);
            }
        }
    }

    private Pair<Integer, List<Condition>> queryCheckMinuteAndConditions(List<Config> configs) {
        int maxMinute = 0;
        ArrayList conditions = new ArrayList();
        for (Config config : configs) {
            if (!this.judgeCurrentInConfigRange(config)) continue;
            List tmpConditions = config.getConditions();
            conditions.addAll(tmpConditions);
            for (Condition con : tmpConditions) {
                int tmpMinute = con.getMinute();
                if (tmpMinute <= maxMinute) continue;
                maxMinute = tmpMinute;
            }
        }
        return new Pair((Object)maxMinute, conditions);
    }

    private String queryCommand(int command) {
        Map commands = this.m_appConfigManager.getRawCommands();
        Command value = (Command)commands.get(command);
        if (value != null) {
            return value.getName();
        }
        throw new RuntimeException("Error config in command code: " + command);
    }

    private Calendar queryDayPeriod(int day) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    private String queryType(String type) {
        String title = "";
        if ("success".equals(type)) {
            title = "\u6210\u529f\u7387\uff08%/\u5206\u949f\uff09";
        } else if ("request".equals(type)) {
            title = "\u8bf7\u6c42\u6570\uff08\u4e2a/\u5206\u949f\uff09";
        } else if ("delay".equals(type)) {
            title = "\u5ef6\u65f6\u5e73\u5747\u503c\uff08\u6beb\u79d2/\u5206\u949f\uff09";
        }
        return title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean active = TimeHelper.sleepToNextMinute();
        while (active) {
            Transaction t = Cat.newTransaction((String)"AlertApp", (String)TimeHelper.getMinuteStr());
            long current = System.currentTimeMillis();
            try {
                MonitorRules monitorRules = this.m_appRuleConfigManager.getMonitorRules();
                Map rules = monitorRules.getRules();
                for (Map.Entry entry : rules.entrySet()) {
                    try {
                        this.processRule((Rule)entry.getValue());
                    }
                    catch (Exception e) {
                        Cat.logError((Throwable)e);
                    }
                }
                t.setStatus("0");
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                Cat.logError((Throwable)e);
            }
            finally {
                t.complete();
            }
            long duration = System.currentTimeMillis() - current;
            try {
                if (duration >= 300000L) continue;
                Thread.sleep(300000L - duration);
            }
            catch (InterruptedException e) {
                active = false;
            }
        }
    }

    public void shutdown() {
    }
}

