/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.app;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.rule.entity.Condition;
import com.dianping.cat.home.rule.entity.MonitorRules;
import com.dianping.cat.home.rule.entity.Rule;
import com.dianping.cat.home.rule.entity.SubCondition;
import com.dianping.cat.home.rule.transform.DefaultSaxParser;
import com.dianping.cat.report.alert.config.BaseRuleConfigManager;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppRuleConfigManager
extends BaseRuleConfigManager
implements Initializable {
    @Inject
    private ContentFetcher m_fetcher;
    private static final String CONFIG_NAME = "appRule";

    public void addDefultRule(String name, Integer commandId) {
        String ruleId = this.buildRuleId(name, commandId);
        Rule rule = new Rule(ruleId);
        rule.addConfig(this.buildDefaultConfig());
        this.m_config.addRule(rule);
        if (!this.storeConfig()) {
            Cat.logError((String)("store app command rule error: " + name + "  " + commandId), (Throwable)new RuntimeException());
        }
    }

    private com.dianping.cat.home.rule.entity.Config buildDefaultConfig() {
        com.dianping.cat.home.rule.entity.Config config = new com.dianping.cat.home.rule.entity.Config();
        config.setStarttime("00:00");
        config.setEndtime("24:00");
        Condition condition = new Condition();
        condition.setAlertType("warning");
        condition.setMinute(Integer.valueOf(3));
        SubCondition minSuccessSubCondition = new SubCondition();
        minSuccessSubCondition.setType("MinVal").setText("95");
        condition.addSubCondition(minSuccessSubCondition);
        config.addCondition(condition);
        return config;
    }

    private String buildRuleId(String name, Integer commandId) {
        return commandId + ";-1;-1;-1;-1;-1;-1;-1:success:" + name;
    }

    public void deleteByCommandId(int commandId) {
        HashSet<String> ids = new HashSet<String>();
        Map rules = this.m_config.getRules();
        for (Map.Entry rule : rules.entrySet()) {
            String id = (String)rule.getKey();
            if (!id.startsWith(commandId + ";")) continue;
            ids.add(id);
        }
        for (String id : ids) {
            rules.remove(id);
        }
    }

    public void deleteDefaultRule(String name, List<Integer> commandIds) {
        for (int commandId : commandIds) {
            String ruleId = this.buildRuleId(name, Integer.valueOf(commandId));
            this.m_config.removeRule(ruleId);
        }
        if (!this.storeConfig()) {
            Cat.logError((String)("delete app command rule error: " + name), (Throwable)new RuntimeException());
        }
    }

    protected String getConfigName() {
        return CONFIG_NAME;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_config = DefaultSaxParser.parse((String)content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse((String)content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_config == null) {
            this.m_config = new MonitorRules();
        }
    }
}

