/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.business;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.company.model.entity.ProductLine;
import com.dianping.cat.consumer.config.ProductLineConfig;
import com.dianping.cat.consumer.metric.MetricConfigManager;
import com.dianping.cat.consumer.metric.config.entity.MetricItemConfig;
import com.dianping.cat.consumer.metric.config.entity.Tag;
import com.dianping.cat.home.rule.entity.Config;
import com.dianping.cat.report.alert.AlarmRule;
import com.dianping.cat.report.alert.AlertResultEntity;
import com.dianping.cat.report.alert.AlertType;
import com.dianping.cat.report.alert.BaseAlert;
import com.dianping.cat.report.alert.MetricReportGroup;
import com.dianping.cat.report.alert.MetricType;
import com.dianping.cat.report.alert.business.BusinessRuleConfigManager;
import com.dianping.cat.report.alert.config.BaseRuleConfigManager;
import com.dianping.cat.report.alert.sender.AlertEntity;
import com.dianping.cat.report.page.metric.service.BaselineService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessAlert
extends BaseAlert {
    public static final String ID = AlertType.Business.getName();
    @Inject
    protected MetricConfigManager m_metricConfigManager;
    @Inject
    protected BusinessRuleConfigManager m_ruleConfigManager;
    @Inject
    protected BaselineService m_baselineService;

    private AlarmRule buildMonitorConfigs(String productline, List<MetricItemConfig> configs) {
        HashMap monitorConfigs = new HashMap();
        for (MetricItemConfig config : configs) {
            List tmpConfigs;
            HashMap<MetricType, List> monitorConfigsByItem = new HashMap<MetricType, List>();
            String metricKey = config.getId();
            if (config.isShowAvg()) {
                tmpConfigs = this.m_ruleConfigManager.queryConfigs(productline, metricKey, MetricType.AVG);
                monitorConfigsByItem.put(MetricType.AVG, tmpConfigs);
            }
            if (config.isShowCount()) {
                tmpConfigs = this.m_ruleConfigManager.queryConfigs(productline, metricKey, MetricType.COUNT);
                monitorConfigsByItem.put(MetricType.COUNT, tmpConfigs);
            }
            if (config.isShowSum()) {
                tmpConfigs = this.m_ruleConfigManager.queryConfigs(productline, metricKey, MetricType.SUM);
                monitorConfigsByItem.put(MetricType.SUM, tmpConfigs);
            }
            monitorConfigs.put(metricKey, monitorConfigsByItem);
        }
        return new AlarmRule(monitorConfigs);
    }

    public String getName() {
        return ID;
    }

    protected Map<String, ProductLine> getProductlines() {
        return this.m_productLineConfigManager.queryMetricProductLines();
    }

    protected BaseRuleConfigManager getRuleConfigManager() {
        return this.m_ruleConfigManager;
    }

    public boolean needAlert(MetricItemConfig config) {
        if (config.getAlarm()) {
            return true;
        }
        List tags = config.getTags();
        for (Tag tag : tags) {
            if (!"\u4e1a\u52a1\u5927\u76d8".equals(tag.getName())) continue;
            return true;
        }
        return false;
    }

    private void processMetricItemConfig(MetricItemConfig config, int minute, Map<MetricType, List<Config>> monitorConfigs, ProductLine productLine, MetricReportGroup reportGroup) {
        if (this.needAlert(config)) {
            List tmpResults;
            String product = productLine.getId();
            String domain = config.getDomain();
            String metric = config.getMetricKey();
            String metricKey = this.m_metricConfigManager.buildMetricKey(domain, config.getType(), metric);
            ArrayList results = new ArrayList();
            if (config.isShowAvg()) {
                tmpResults = this.processMetricType(minute, monitorConfigs.get(MetricType.AVG), reportGroup, metricKey, MetricType.AVG);
                results.addAll(tmpResults);
            }
            if (config.isShowCount()) {
                tmpResults = this.processMetricType(minute, monitorConfigs.get(MetricType.COUNT), reportGroup, metricKey, MetricType.COUNT);
                results.addAll(tmpResults);
            }
            if (config.isShowSum()) {
                tmpResults = this.processMetricType(minute, monitorConfigs.get(MetricType.SUM), reportGroup, metricKey, MetricType.SUM);
                results.addAll(tmpResults);
            }
            if (results.size() > 0) {
                this.updateAlertStatus(product, metricKey);
                this.sendBusinessAlerts(product, domain, metric, results);
            }
        }
    }

    protected List<AlertResultEntity> processMetricType(int minute, List<Config> configs, MetricReportGroup reportGroup, String metricKey, MetricType type) {
        Pair conditionPair = this.m_ruleConfigManager.convertConditions(configs);
        if (conditionPair != null) {
            int ruleMinute = (Integer)conditionPair.getKey();
            Cat.logEvent((String)"BussinessMetric", (String)(metricKey + "," + type.getName()), (String)"0", (String)("minute=" + minute + "&ruleMinute=" + ruleMinute));
            double[] value = reportGroup.extractData(minute, ruleMinute, metricKey, type);
            double[] baseline = this.m_baselineService.queryBaseline(minute, ruleMinute, metricKey, type);
            List conditions = (List)conditionPair.getValue();
            return this.m_dataChecker.checkData(value, baseline, conditions);
        }
        return new ArrayList<AlertResultEntity>();
    }

    protected void processProductLine(ProductLine productLine) {
        String productId = productLine.getId();
        List domains = this.m_productLineConfigManager.queryDomainsByProductLine(productId, ProductLineConfig.METRIC);
        List configs = this.m_metricConfigManager.queryMetricItemConfigs((Collection)domains);
        int nowMinute = this.calAlreadyMinute();
        AlarmRule monitorConfigs = this.buildMonitorConfigs(productId, configs);
        int maxMinute = monitorConfigs.calMaxRuleMinute();
        if (maxMinute > 0) {
            MetricReportGroup reportGroup = this.m_service.prepareDatas(productId, nowMinute, maxMinute);
            if (reportGroup.isDataReady()) {
                for (MetricItemConfig config : configs) {
                    try {
                        Map itemConfig = (Map)monitorConfigs.getConfigs().get(config.getId());
                        this.processMetricItemConfig(config, nowMinute, itemConfig, productLine, reportGroup);
                    }
                    catch (Exception e) {
                        Cat.logError((Throwable)e);
                    }
                }
            } else {
                Cat.logEvent((String)"AlertDataNotFount", (String)this.getName());
            }
        } else {
            Cat.logEvent((String)"NotAlertRule", (String)productId);
        }
    }

    private void sendBusinessAlerts(String productlineName, String domain, String metricName, List<AlertResultEntity> alertResults) {
        for (AlertResultEntity alertResult : alertResults) {
            AlertEntity entity = new AlertEntity();
            entity.setDate(alertResult.getAlertTime()).setContent(alertResult.getContent()).setLevel(alertResult.getAlertLevel());
            entity.setMetric(metricName).setType(this.getName()).setGroup(productlineName);
            entity.getParas().put("domain", domain);
            this.m_sendManager.addAlert(entity);
        }
    }
}

