/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.business;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.consumer.metric.MetricConfigManager;
import com.dianping.cat.consumer.metric.config.entity.MetricItemConfig;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.rule.entity.Condition;
import com.dianping.cat.home.rule.entity.MetricItem;
import com.dianping.cat.home.rule.entity.MonitorRules;
import com.dianping.cat.home.rule.entity.Rule;
import com.dianping.cat.home.rule.entity.SubCondition;
import com.dianping.cat.home.rule.transform.DefaultSaxParser;
import com.dianping.cat.report.alert.MetricType;
import com.dianping.cat.report.alert.config.BaseRuleConfigManager;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessRuleConfigManager
extends BaseRuleConfigManager
implements Initializable {
    @Inject
    protected MetricConfigManager m_metricConfigManager;
    @Inject
    private ContentFetcher m_fetcher;
    private static final String CONFIG_NAME = "businessRuleConfig";

    private com.dianping.cat.home.rule.entity.Config buildDefaultConfig() {
        com.dianping.cat.home.rule.entity.Config config = new com.dianping.cat.home.rule.entity.Config();
        config.setStarttime("00:00");
        config.setEndtime("24:00");
        Condition condition = new Condition();
        SubCondition descPerSubcon = new SubCondition();
        SubCondition descValSubcon = new SubCondition();
        SubCondition flucPerSubcon = new SubCondition();
        descPerSubcon.setType("DescPer").setText("50");
        descValSubcon.setType("DescVal").setText("100");
        flucPerSubcon.setType("FluDescPer").setText("20");
        condition.addSubCondition(descPerSubcon).addSubCondition(descValSubcon).addSubCondition(flucPerSubcon);
        config.addCondition(condition);
        return config;
    }

    private Rule buildDefaultRule(String product, String metricKey) {
        Rule rule = new Rule(metricKey);
        MetricItem item = new MetricItem();
        item.setProductText(product);
        item.setMetricItemText(metricKey);
        MetricItemConfig metricItem = this.m_metricConfigManager.queryMetricItemConfig(metricKey);
        if (metricItem != null) {
            if (metricItem.isShowAvg()) {
                item.setMonitorAvg(Boolean.valueOf(true));
            }
            if (metricItem.isShowCount()) {
                item.setMonitorCount(Boolean.valueOf(true));
            }
            if (metricItem.isShowSum()) {
                item.setMonitorSum(Boolean.valueOf(true));
            }
        }
        rule.addMetricItem(item);
        rule.addConfig(this.buildDefaultConfig());
        return rule;
    }

    protected String getConfigName() {
        return CONFIG_NAME;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_config = DefaultSaxParser.parse((String)content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse((String)content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_config == null) {
            this.m_config = new MonitorRules();
        }
    }

    public List<com.dianping.cat.home.rule.entity.Config> queryConfigs(String product, String metricKey, MetricType type) {
        Rule rule = (Rule)this.m_config.getRules().get(metricKey);
        ArrayList<com.dianping.cat.home.rule.entity.Config> configs = new ArrayList<com.dianping.cat.home.rule.entity.Config>();
        if (rule == null) {
            configs.add(this.buildDefaultConfig());
            return configs;
        }
        for (MetricItem item : rule.getMetricItems()) {
            if (type == MetricType.COUNT && item.isMonitorCount()) {
                configs.addAll(rule.getConfigs());
                break;
            }
            if (type == MetricType.AVG && item.isMonitorAvg()) {
                configs.addAll(rule.getConfigs());
                break;
            }
            if (type == MetricType.SUM && item.isMonitorSum()) {
                configs.addAll(rule.getConfigs());
                break;
            }
            Cat.logError((String)("No Metric Type find. product:" + product + " metric key:" + metricKey), (Throwable)new RuntimeException());
        }
        if (configs.size() == 0) {
            configs.add(this.buildDefaultConfig());
        } else {
            Cat.logEvent((String)("FindRule:" + this.getConfigName()), (String)rule.getId(), (String)"0", (String)(product + "," + metricKey));
        }
        return this.decorateConfigOnRead(configs);
    }

    public Rule queryRule(String product, String metricKey) {
        Rule rule = (Rule)this.m_config.getRules().get(metricKey);
        if (rule != null) {
            return this.copyRule(rule);
        }
        return this.buildDefaultRule(product, metricKey);
    }
}

