/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.config;

import com.dianping.cat.Cat;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.rule.entity.Condition;
import com.dianping.cat.home.rule.entity.MetricItem;
import com.dianping.cat.home.rule.entity.MonitorRules;
import com.dianping.cat.home.rule.entity.Rule;
import com.dianping.cat.home.rule.entity.SubCondition;
import com.dianping.cat.home.rule.transform.DefaultJsonParser;
import com.dianping.cat.home.rule.transform.DefaultSaxParser;
import com.dianping.cat.report.alert.AlarmRule;
import com.dianping.cat.report.alert.MetricType;
import com.dianping.cat.report.alert.RuleType;
import com.dianping.cat.report.alert.config.UserDefinedRuleManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRuleConfigManager {
    @Inject
    protected ConfigDao m_configDao;
    @Inject
    protected UserDefinedRuleManager m_manager;
    protected int m_configId;
    protected MonitorRules m_config;

    private int calMaxNum(Set<Integer> nums) {
        int max = 0;
        for (int n : nums) {
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    private boolean checkTimeValidate(com.dianping.cat.home.rule.entity.Config config) {
        try {
            return this.compareTime(config.getStarttime(), config.getEndtime());
        }
        catch (Exception ex) {
            Cat.logError((String)("throw exception when judge time: " + config.toString()), (Throwable)ex);
            return false;
        }
    }

    public boolean compareTime(String start, String end) {
        String[] startTime = start.split(":");
        int hourStart = Integer.parseInt(startTime[0]);
        int minuteStart = Integer.parseInt(startTime[1]);
        int startMinute = hourStart * 60 + minuteStart;
        String[] endTime = end.split(":");
        int hourEnd = Integer.parseInt(endTime[0]);
        int minuteEnd = Integer.parseInt(endTime[1]);
        int endMinute = hourEnd * 60 + minuteEnd;
        Calendar cal = Calendar.getInstance();
        int current = cal.get(11) * 60 + cal.get(12);
        return current >= startMinute && current <= endMinute;
    }

    public Pair<Integer, List<Condition>> convertConditions(List<com.dianping.cat.home.rule.entity.Config> configs) {
        int maxMinute = 0;
        ArrayList conditions = new ArrayList();
        for (com.dianping.cat.home.rule.entity.Config config : configs) {
            if (!this.checkTimeValidate(config)) continue;
            List tmpConditions = config.getConditions();
            conditions.addAll(tmpConditions);
            for (Condition con : tmpConditions) {
                int tmpMinute = con.getMinute();
                if (tmpMinute <= maxMinute) continue;
                maxMinute = tmpMinute;
            }
        }
        if (maxMinute > 0) {
            return new Pair((Object)maxMinute, conditions);
        }
        return null;
    }

    protected Rule copyRule(Rule rule) {
        try {
            return (Rule)DefaultSaxParser.parseEntity(Rule.class, (String)rule.toString());
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return null;
        }
    }

    protected void decorateConfigOnDelete(List<com.dianping.cat.home.rule.entity.Config> configs) {
        for (com.dianping.cat.home.rule.entity.Config config : configs) {
            for (Condition condition : config.getConditions()) {
                for (SubCondition subCondition : condition.getSubConditions()) {
                    if (!RuleType.UserDefine.getId().equals(subCondition.getType())) continue;
                    try {
                        String id = subCondition.getText();
                        this.m_manager.removeById(id);
                    }
                    catch (DalException e) {
                        Cat.logError((Throwable)e);
                    }
                }
            }
        }
    }

    protected List<com.dianping.cat.home.rule.entity.Config> decorateConfigOnRead(List<com.dianping.cat.home.rule.entity.Config> originConfigs) {
        List configs = this.deepCopy(originConfigs);
        for (com.dianping.cat.home.rule.entity.Config config : configs) {
            for (Condition condition : config.getConditions()) {
                for (SubCondition subCondition : condition.getSubConditions()) {
                    if (!RuleType.UserDefine.getId().equals(subCondition.getType())) continue;
                    try {
                        String id = subCondition.getText();
                        subCondition.setText(this.m_manager.getUserDefineText(id));
                    }
                    catch (DalException e) {
                        Cat.logError((Throwable)e);
                    }
                }
            }
        }
        return configs;
    }

    protected Map<MetricType, List<com.dianping.cat.home.rule.entity.Config>> decorateConfigOnRead(Map<MetricType, List<com.dianping.cat.home.rule.entity.Config>> originConfigs) {
        HashMap<MetricType, List<com.dianping.cat.home.rule.entity.Config>> configs = new HashMap<MetricType, List<com.dianping.cat.home.rule.entity.Config>>();
        for (Map.Entry<MetricType, List<com.dianping.cat.home.rule.entity.Config>> originConfig : originConfigs.entrySet()) {
            configs.put(originConfig.getKey(), this.decorateConfigOnRead(originConfig.getValue()));
        }
        return configs;
    }

    private void decorateConfigOnStore(List<com.dianping.cat.home.rule.entity.Config> configs) throws DalException {
        for (com.dianping.cat.home.rule.entity.Config config : configs) {
            for (Condition condition : config.getConditions()) {
                for (SubCondition subCondition : condition.getSubConditions()) {
                    if (!RuleType.UserDefine.getId().equals(subCondition.getType())) continue;
                    try {
                        String userDefinedText = subCondition.getText();
                        subCondition.setText(this.m_manager.addUserDefineText(userDefinedText));
                    }
                    catch (DalException e) {
                        Cat.logError((Throwable)e);
                    }
                }
            }
        }
    }

    private List<com.dianping.cat.home.rule.entity.Config> deepCopy(List<com.dianping.cat.home.rule.entity.Config> originConfigs) {
        ArrayList<com.dianping.cat.home.rule.entity.Config> result = new ArrayList<com.dianping.cat.home.rule.entity.Config>();
        for (com.dianping.cat.home.rule.entity.Config config : originConfigs) {
            try {
                com.dianping.cat.home.rule.entity.Config copiedConfig = (com.dianping.cat.home.rule.entity.Config)DefaultSaxParser.parseEntity(com.dianping.cat.home.rule.entity.Config.class, (String)config.toString());
                result.add(copiedConfig);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return result;
    }

    public String deleteRule(String key) {
        Rule rule = (Rule)this.m_config.getRules().get(key);
        if (rule != null) {
            this.decorateConfigOnDelete(rule.getConfigs());
            this.m_config.getRules().remove(key);
        }
        return this.m_config.toString();
    }

    private void extractConifgsByProduct(String product, Rule rule, Map<String, Map<Integer, Map<MetricType, List<com.dianping.cat.home.rule.entity.Config>>>> configs) {
        List items = rule.getMetricItems();
        for (MetricItem item : items) {
            String configProduct = item.getProductText();
            String configMetricKey = item.getMetricItemText();
            int matchLevel = this.validateRegex(configProduct, product);
            if (matchLevel <= 0) continue;
            Map<Integer, Map<MetricType, List<com.dianping.cat.home.rule.entity.Config>>> configsByPriority = configs.get(configMetricKey);
            if (configsByPriority == null) {
                configsByPriority = new HashMap<Integer, Map<MetricType, List<com.dianping.cat.home.rule.entity.Config>>>();
                configs.put(configMetricKey, configsByPriority);
            }
            HashMap<MetricType, List> configsByType = new HashMap<MetricType, List>();
            if (item.isMonitorAvg()) {
                configsByType.put(MetricType.AVG, rule.getConfigs());
            }
            if (item.isMonitorCount()) {
                configsByType.put(MetricType.COUNT, rule.getConfigs());
            }
            if (item.isMonitorSum()) {
                configsByType.put(MetricType.SUM, rule.getConfigs());
            }
            configsByPriority.put(matchLevel, configsByType);
        }
    }

    private Map<String, Map<MetricType, List<com.dianping.cat.home.rule.entity.Config>>> extractMaxPriorityConfigs(Map<String, Map<Integer, Map<MetricType, List<com.dianping.cat.home.rule.entity.Config>>>> configs) {
        HashMap<String, Map<MetricType, List<com.dianping.cat.home.rule.entity.Config>>> result = new HashMap<String, Map<MetricType, List<com.dianping.cat.home.rule.entity.Config>>>();
        for (Map.Entry<String, Map<Integer, Map<MetricType, List<com.dianping.cat.home.rule.entity.Config>>>> entry : configs.entrySet()) {
            String metirc = entry.getKey();
            Map<Integer, Map<MetricType, List<com.dianping.cat.home.rule.entity.Config>>> priorityMap = entry.getValue();
            int maxPriority = this.calMaxNum(priorityMap.keySet());
            Map<MetricType, List<com.dianping.cat.home.rule.entity.Config>> configsByType = priorityMap.get(maxPriority);
            result.put(metirc, this.decorateConfigOnRead(configsByType));
            Cat.logEvent((String)("FindRule:" + this.getConfigName()), (String)metirc, (String)"0", null);
        }
        return result;
    }

    protected abstract String getConfigName();

    protected List<Rule> getMaxPriorityRules(Map<Integer, List<Rule>> rules) {
        Set<Integer> keys = rules.keySet();
        int maxKey = 0;
        for (int key : keys) {
            if (key <= maxKey) continue;
            maxKey = key;
        }
        List<Rule> finalRules = rules.get(maxKey);
        if (finalRules == null) {
            finalRules = new ArrayList<Rule>();
        }
        return finalRules;
    }

    public MonitorRules getMonitorRules() {
        return this.m_config;
    }

    public boolean insert(String xml) {
        try {
            this.m_config = DefaultSaxParser.parse((String)xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public AlarmRule queryConfigs(String product) {
        HashMap configs = new HashMap();
        for (Rule rule : this.m_config.getRules().values()) {
            this.extractConifgsByProduct(product, rule, configs);
        }
        Map maxPriority = this.extractMaxPriorityConfigs(configs);
        return new AlarmRule(maxPriority);
    }

    public Rule queryRule(String key) {
        Rule rule = (Rule)this.m_config.getRules().get(key);
        if (rule != null) {
            return this.copyRule(rule);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean storeConfig() {
        BaseRuleConfigManager baseRuleConfigManager = this;
        synchronized (baseRuleConfigManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(this.getConfigName());
                config.setContent(this.m_config.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }

    public String updateRule(String id, String metricsStr, String configsStr) throws Exception {
        Rule rule = new Rule(id);
        List metricItems = DefaultJsonParser.parseArray(MetricItem.class, (String)metricsStr);
        List configs = DefaultJsonParser.parseArray(com.dianping.cat.home.rule.entity.Config.class, (String)configsStr);
        for (MetricItem metricItem : metricItems) {
            rule.addMetricItem(metricItem);
        }
        for (com.dianping.cat.home.rule.entity.Config config : configs) {
            rule.addConfig(config);
        }
        this.decorateConfigOnStore(rule.getConfigs());
        this.m_config.getRules().put(id, rule);
        return this.m_config.toString();
    }

    public int validate(String productText, String metricKeyText, String product, String metricKey) {
        int metricMatchResult;
        int groupMatchResult = this.validateRegex(productText, product);
        if (groupMatchResult > 0 && (metricMatchResult = this.validateRegex(metricKeyText, metricKey)) > 0) {
            return groupMatchResult;
        }
        return 0;
    }

    public int validateRegex(String regexText, String text) {
        if (StringUtils.isEmpty((String)regexText)) {
            return 1;
        }
        if (regexText.equalsIgnoreCase(text)) {
            return 3;
        }
        Pattern p = Pattern.compile(regexText);
        Matcher m = p.matcher(text);
        if (m.find()) {
            return 2;
        }
        return 0;
    }
}

