/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.exception;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.exception.entity.ExceptionExclude;
import com.dianping.cat.home.exception.entity.ExceptionLimit;
import com.dianping.cat.home.exception.entity.ExceptionRuleConfig;
import com.dianping.cat.home.exception.transform.DefaultSaxParser;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionRuleConfigManager
implements Initializable {
    @Inject
    private ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    private int m_configId;
    private ExceptionRuleConfig m_exceptionRuleConfig;
    private static final String CONFIG_NAME = "exceptionRuleConfig";
    public static String DEFAULT_STRING = "Default";
    public static String TOTAL_STRING = "Total";

    public boolean deleteExceptionExclude(String domain, String exceptionName) {
        this.m_exceptionRuleConfig.removeExceptionExclude(domain + ":" + exceptionName);
        return this.storeConfig();
    }

    public boolean deleteExceptionLimit(String domain, String exceptionName) {
        this.m_exceptionRuleConfig.removeExceptionLimit(domain + ":" + exceptionName);
        return this.storeConfig();
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_exceptionRuleConfig = DefaultSaxParser.parse((String)content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_exceptionRuleConfig = DefaultSaxParser.parse((String)content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_exceptionRuleConfig == null) {
            this.m_exceptionRuleConfig = new ExceptionRuleConfig();
        }
    }

    public boolean isExcluded(String domain, String exceptionName) {
        boolean excluded = false;
        ExceptionExclude result = this.queryExceptionExclude(domain, exceptionName);
        if (result != null) {
            excluded = true;
        }
        return excluded;
    }

    public boolean insertExceptionExclude(ExceptionExclude exclude) {
        String id = exclude.getDomain() + ":" + exclude.getName();
        this.m_exceptionRuleConfig.getExceptionExcludes().put(id, exclude);
        return this.storeConfig();
    }

    public boolean insertExceptionLimit(ExceptionLimit limit) {
        String id = limit.getDomain() + ":" + limit.getName();
        this.m_exceptionRuleConfig.getExceptionLimits().put(id, limit);
        return this.storeConfig();
    }

    public List<ExceptionExclude> queryAllExceptionExcludes() {
        return new ArrayList<ExceptionExclude>(this.m_exceptionRuleConfig.getExceptionExcludes().values());
    }

    public List<ExceptionLimit> queryAllExceptionLimits() {
        return new ArrayList<ExceptionLimit>(this.m_exceptionRuleConfig.getExceptionLimits().values());
    }

    public ExceptionExclude queryExceptionExclude(String domain, String exceptionName) {
        ExceptionExclude exceptionExclude = this.m_exceptionRuleConfig.findExceptionExclude(domain + ":" + exceptionName);
        if (exceptionExclude == null) {
            exceptionExclude = this.m_exceptionRuleConfig.findExceptionExclude(DEFAULT_STRING + ":" + exceptionName);
        }
        return exceptionExclude;
    }

    public ExceptionLimit queryExceptionLimit(String domain, String exceptionName) {
        ExceptionLimit exceptionLimit = this.m_exceptionRuleConfig.findExceptionLimit(domain + ":" + exceptionName);
        if (exceptionLimit == null) {
            exceptionLimit = this.m_exceptionRuleConfig.findExceptionLimit(DEFAULT_STRING + ":" + exceptionName);
        }
        return exceptionLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        ExceptionRuleConfigManager exceptionRuleConfigManager = this;
        synchronized (exceptionRuleConfigManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.m_exceptionRuleConfig.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }

    public ExceptionLimit queryTotalLimitByDomain(String domain) {
        return this.queryExceptionLimit(domain, TOTAL_STRING);
    }
}

