/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.exception;

import com.dianping.cat.Cat;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.alert.AlertType;
import com.dianping.cat.report.alert.exception.AlertExceptionBuilder;
import com.dianping.cat.report.alert.exception.ExceptionAlert;
import com.dianping.cat.report.alert.sender.AlertEntity;
import com.dianping.cat.report.page.dependency.TopMetric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class FrontEndExceptionAlert
extends ExceptionAlert {
    public String getName() {
        return AlertType.FrontEndException.getName();
    }

    private void handleFrontEndException(TopMetric.Item frontEndItem) {
        List alertExceptions = this.m_alertBuilder.buildFrontEndAlertExceptions(frontEndItem);
        for (AlertExceptionBuilder.AlertException exception : alertExceptions) {
            try {
                String metricName = exception.getName();
                AlertEntity entity = new AlertEntity();
                entity.setDate(new Date()).setContent(exception.toString()).setLevel(exception.getType());
                entity.setMetric(metricName).setType(this.getName()).setGroup(metricName);
                this.m_sendManager.addAlert(entity);
                System.out.println(entity);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean active = TimeHelper.sleepToNextMinute();
        while (active) {
            long current = System.currentTimeMillis();
            Transaction t = Cat.newTransaction((String)"AlertFrontEnd", (String)TimeHelper.getMinuteStr());
            try {
                TopMetric topMetric = this.buildTopMetric(new Date(current - 120000L));
                Collection itemLists = topMetric.getError().getResult().values();
                List itemList = new ArrayList();
                if (!itemLists.isEmpty()) {
                    itemList = (List)itemLists.iterator().next();
                }
                for (TopMetric.Item item : itemList) {
                    if (!"FrontEnd".equals(item.getDomain())) continue;
                    this.handleFrontEndException(item);
                    break;
                }
                t.setStatus("0");
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
            }
            finally {
                t.complete();
            }
            long duration = System.currentTimeMillis() - current;
            try {
                if (duration >= 60000L) continue;
                Thread.sleep(60000L - duration);
            }
            catch (InterruptedException e) {
                active = false;
            }
        }
    }

    public void shutdown() {
    }
}

