/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.heartbeat;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.consumer.company.model.entity.ProductLine;
import com.dianping.cat.consumer.heartbeat.model.entity.Detail;
import com.dianping.cat.consumer.heartbeat.model.entity.Extension;
import com.dianping.cat.consumer.heartbeat.model.entity.HeartbeatReport;
import com.dianping.cat.consumer.heartbeat.model.entity.Machine;
import com.dianping.cat.consumer.heartbeat.model.entity.Period;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.home.rule.entity.Condition;
import com.dianping.cat.home.rule.entity.Config;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.alert.AlertResultEntity;
import com.dianping.cat.report.alert.AlertType;
import com.dianping.cat.report.alert.BaseAlert;
import com.dianping.cat.report.alert.config.BaseRuleConfigManager;
import com.dianping.cat.report.alert.heartbeat.HeartbeatRuleConfigManager;
import com.dianping.cat.report.alert.sender.AlertEntity;
import com.dianping.cat.report.page.heartbeat.config.HeartbeatDisplayPolicyManager;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeartbeatAlert
extends BaseAlert {
    @Inject(type=ModelService.class, value={"heartbeat"})
    private ModelService<HeartbeatReport> m_heartbeatService;
    @Inject(type=ModelService.class, value={"transaction"})
    private ModelService<TransactionReport> m_transactionService;
    @Inject
    private HeartbeatDisplayPolicyManager m_displayManager;
    @Inject
    private ServerFilterConfigManager m_serverFilterConfigManager;
    @Inject
    protected HeartbeatRuleConfigManager m_ruleConfigManager;

    private Map<String, double[]> buildArrayForExtensions(List<Period> periods) {
        LinkedHashMap<String, double[]> map = new LinkedHashMap<String, double[]>();
        for (Period period : periods) {
            List metrics = this.extractExtentionMetrics(period);
            int index = period.getMinute();
            for (Pair metric : metrics) {
                String key = (String)metric.getKey() + ":" + (String)metric.getValue();
                double[] array = (double[])map.get(key);
                if (array == null) {
                    array = new double[60];
                    map.put(key, array);
                }
                try {
                    String groupName = (String)metric.getKey();
                    String metricName = (String)metric.getValue();
                    int unit = this.m_displayManager.queryUnit(groupName, metricName);
                    Detail detail = period.findOrCreateExtension(groupName).findOrCreateDetail(metricName);
                    array[index] = detail.getValue() / (double)unit;
                }
                catch (Exception e) {
                    array[index] = 0.0;
                }
            }
        }
        return map;
    }

    private int calMaxMinute(Map<String, List<Config>> configs) {
        int maxMinute = 0;
        for (List<Config> tmpConfigs : configs.values()) {
            for (Config config : tmpConfigs) {
                for (Condition condition : config.getConditions()) {
                    int tmpMinute = condition.getMinute();
                    if (tmpMinute <= maxMinute) continue;
                    maxMinute = tmpMinute;
                }
            }
        }
        return maxMinute;
    }

    private double[] extract(double[] lastHourValues, double[] currentHourValues, int maxMinute, int alreadyMinute) {
        if (lastHourValues != null && currentHourValues != null) {
            int i;
            int lastLength = maxMinute - alreadyMinute - 1;
            double[] result = new double[maxMinute];
            for (i = 0; i < lastLength; ++i) {
                result[i] = lastHourValues[60 - lastLength + i];
            }
            for (i = lastLength; i < maxMinute; ++i) {
                result[i] = currentHourValues[i - lastLength];
            }
            return result;
        }
        return null;
    }

    private double[] extract(double[] values, int maxMinute, int alreadyMinute) {
        if (values != null) {
            double[] result = new double[maxMinute];
            for (int i = 0; i < maxMinute; ++i) {
                result[i] = values[alreadyMinute + 1 - maxMinute + i];
            }
            return result;
        }
        return null;
    }

    private List<Pair<String, String>> extractExtentionMetrics(Period period) {
        ArrayList<Pair<String, String>> metrics = new ArrayList<Pair<String, String>>();
        for (Extension extension : period.getExtensions().values()) {
            Map details = extension.getDetails();
            for (Map.Entry detail : details.entrySet()) {
                metrics.add((Pair<String, String>)new Pair((Object)extension.getId(), detail.getKey()));
            }
        }
        return metrics;
    }

    private Map<String, double[]> buildBaseValue(Machine machine) {
        Map map = this.buildArrayForExtensions(machine.getPeriods());
        for (String id : map.keySet()) {
            String[] str = id.split(":");
            if (!this.m_displayManager.isDelta(str[0], str[1])) continue;
            double[] sources = (double[])map.get(id);
            double[] targets = new double[60];
            for (int i = 1; i < 60; ++i) {
                double delta;
                if (!(sources[i - 1] > 0.0) || !((delta = sources[i] - sources[i - 1]) >= 0.0)) continue;
                targets[i] = delta;
            }
            map.put(id, targets);
        }
        return map;
    }

    private HeartbeatReport generateCurrentReport(String domain, int start, int end) {
        long currentMill = System.currentTimeMillis();
        long currentHourMill = currentMill - currentMill % 3600000L;
        return this.generateReport(domain, currentHourMill, start, end);
    }

    private HeartbeatReport generateLastReport(String domain, int start, int end) {
        long currentMill = System.currentTimeMillis();
        long lastHourMill = currentMill - currentMill % 3600000L - 3600000L;
        return this.generateReport(domain, lastHourMill, start, end);
    }

    private HeartbeatReport generateReport(String domain, long date, int start, int end) {
        ModelRequest request = new ModelRequest(domain, date).setProperty("min", String.valueOf(start)).setProperty("max", String.valueOf(end)).setProperty("ip", "All").setProperty("requireAll", "true");
        if (this.m_heartbeatService.isEligable(request)) {
            ModelResponse response = this.m_heartbeatService.invoke(request);
            if (response != null) {
                return (HeartbeatReport)response.getModel();
            }
            return null;
        }
        throw new RuntimeException("Internal error: no eligable ip service registered for " + request + "!");
    }

    public String getName() {
        return AlertType.HeartBeat.getName();
    }

    protected Map<String, ProductLine> getProductlines() {
        throw new RuntimeException("get productline is not support by heartbeat alert");
    }

    protected BaseRuleConfigManager getRuleConfigManager() {
        return this.m_ruleConfigManager;
    }

    private void processDomain(String domain) {
        int max;
        int min;
        int minute = this.calAlreadyMinute();
        Map configsMap = this.m_ruleConfigManager.queryConfigsByDomain(domain);
        int domainMaxMinute = this.calMaxMinute(configsMap);
        HeartbeatReport currentReport = null;
        HeartbeatReport lastReport = null;
        boolean isDataReady = false;
        if (minute >= domainMaxMinute - 1) {
            min = minute - domainMaxMinute + 1;
            max = minute;
            currentReport = this.generateCurrentReport(domain, min, max);
            if (currentReport != null) {
                isDataReady = true;
            }
        } else if (minute < 0) {
            min = minute + 60 - domainMaxMinute + 1;
            max = minute + 60;
            lastReport = this.generateLastReport(domain, min, max);
            if (lastReport != null) {
                isDataReady = true;
            }
        } else {
            int lastLength = domainMaxMinute - minute - 1;
            int lastMin = 60 - lastLength;
            currentReport = this.generateCurrentReport(domain, 0, minute);
            lastReport = this.generateLastReport(domain, lastMin, 59);
            if (lastReport != null && currentReport != null) {
                isDataReady = true;
            }
        }
        if (isDataReady) {
            for (Map.Entry entry : configsMap.entrySet()) {
                double[] values;
                double[] arguments;
                String ip;
                String metric = (String)entry.getKey();
                List configs = (List)entry.getValue();
                Pair conditionPair = this.m_ruleConfigManager.convertConditions(configs);
                if (conditionPair == null) continue;
                int maxMinute = (Integer)conditionPair.getKey();
                List conditions = (List)conditionPair.getValue();
                if (minute >= maxMinute - 1) {
                    for (Machine machine : currentReport.getMachines().values()) {
                        ip = machine.getIp();
                        arguments = (double[])this.buildBaseValue(machine).get(metric);
                        if (arguments == null) continue;
                        values = this.extract(arguments, maxMinute, minute);
                        this.processMeitrc(domain, ip, metric, conditions, maxMinute, values);
                    }
                    continue;
                }
                if (minute < 0) {
                    for (Machine machine : lastReport.getMachines().values()) {
                        ip = machine.getIp();
                        arguments = (double[])this.buildBaseValue(machine).get(metric);
                        if (arguments == null) continue;
                        values = this.extract(arguments, maxMinute, 59);
                        this.processMeitrc(domain, ip, metric, conditions, maxMinute, values);
                    }
                    continue;
                }
                for (Machine lastMachine : lastReport.getMachines().values()) {
                    ip = lastMachine.getIp();
                    Machine currentMachine = (Machine)currentReport.getMachines().get(ip);
                    if (currentMachine == null) continue;
                    Map lastHourArguments = this.buildBaseValue(lastMachine);
                    Map currentHourArguments = this.buildBaseValue(currentMachine);
                    if (lastHourArguments == null || currentHourArguments == null) continue;
                    double[] values2 = this.extract((double[])lastHourArguments.get(metric), (double[])currentHourArguments.get(metric), maxMinute, minute);
                    this.processMeitrc(domain, ip, metric, conditions, maxMinute, values2);
                }
            }
        }
    }

    private void processMeitrc(String domain, String ip, String metric, List<Condition> conditions, int maxMinute, double[] values) {
        try {
            if (values != null) {
                double[] baseline = new double[maxMinute];
                List alerts = this.m_dataChecker.checkData(values, baseline, conditions);
                for (AlertResultEntity alertResult : alerts) {
                    AlertEntity entity = new AlertEntity();
                    entity.setDate(alertResult.getAlertTime()).setContent(alertResult.getContent()).setLevel(alertResult.getAlertLevel());
                    entity.setMetric(metric).setType(this.getName()).setGroup(domain);
                    entity.getParas().put("ip", ip);
                    this.m_sendManager.addAlert(entity);
                }
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    private Set<String> queryDomains() {
        HashSet<String> domains = new HashSet<String>();
        ModelRequest request = new ModelRequest("cat", System.currentTimeMillis());
        if (this.m_transactionService.isEligable(request)) {
            ModelResponse response = this.m_transactionService.invoke(request);
            domains.addAll(((TransactionReport)response.getModel()).getDomainNames());
        }
        return domains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean active = TimeHelper.sleepToNextMinute();
        while (active) {
            Transaction t = Cat.newTransaction((String)"AlertHeartbeat", (String)TimeHelper.getMinuteStr());
            long current = System.currentTimeMillis();
            try {
                Set domains = this.queryDomains();
                for (String domain : domains) {
                    if (!this.m_serverFilterConfigManager.validateDomain(domain) || !StringUtils.isNotEmpty((String)domain)) continue;
                    try {
                        this.processDomain(domain);
                    }
                    catch (Exception e) {
                        Cat.logError((Throwable)e);
                    }
                }
                t.setStatus("0");
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
            }
            finally {
                t.complete();
            }
            long duration = System.currentTimeMillis() - current;
            try {
                if (duration >= 60000L) continue;
                Thread.sleep(60000L - duration);
            }
            catch (InterruptedException e) {
                active = false;
            }
        }
    }
}

