/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.heartbeat;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.rule.entity.MetricItem;
import com.dianping.cat.home.rule.entity.MonitorRules;
import com.dianping.cat.home.rule.entity.Rule;
import com.dianping.cat.home.rule.transform.DefaultSaxParser;
import com.dianping.cat.report.alert.config.BaseRuleConfigManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeartbeatRuleConfigManager
extends BaseRuleConfigManager
implements Initializable {
    @Inject
    private ContentFetcher m_fetcher;
    private static final String CONFIG_NAME = "heartbeatRuleConfig";

    private void addRuleToMap(Rule rule, String metric, int priority, Map<String, Map<Integer, List<Rule>>> rules) {
        List<Rule> ruleList;
        Map<Integer, List<Rule>> rulesByPriority = rules.get(metric);
        if (rulesByPriority == null) {
            rulesByPriority = new HashMap<Integer, List<Rule>>();
            rules.put(metric, rulesByPriority);
        }
        if ((ruleList = rulesByPriority.get(priority)) == null) {
            ruleList = new ArrayList<Rule>();
            rulesByPriority.put(priority, ruleList);
        }
        ruleList.add(rule);
    }

    private Map<String, List<com.dianping.cat.home.rule.entity.Config>> extractConfigs(String domain, Map<String, Map<Integer, List<Rule>>> rulesByMetricPriority) {
        HashMap<String, List<com.dianping.cat.home.rule.entity.Config>> result = new HashMap<String, List<com.dianping.cat.home.rule.entity.Config>>();
        for (Map.Entry<String, Map<Integer, List<Rule>>> entry : rulesByMetricPriority.entrySet()) {
            String metric = entry.getKey();
            List rules = this.getMaxPriorityRules(entry.getValue());
            ArrayList configs = new ArrayList();
            for (Rule rule : rules) {
                configs.addAll(rule.getConfigs());
                String nameValuePairs = "product=" + domain + "&metricKey=" + metric;
                Cat.logEvent((String)("FindRule:" + this.getConfigName()), (String)rule.getId(), (String)"0", (String)nameValuePairs);
            }
            result.put(metric, configs);
        }
        return result;
    }

    protected String getConfigName() {
        return CONFIG_NAME;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_config = DefaultSaxParser.parse((String)content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse((String)content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_config == null) {
            this.m_config = new MonitorRules();
        }
    }

    public Map<String, List<com.dianping.cat.home.rule.entity.Config>> queryConfigsByDomain(String domain) {
        HashMap rules = new HashMap();
        for (Rule rule : this.m_config.getRules().values()) {
            for (MetricItem metricItem : rule.getMetricItems()) {
                String domainPattern = metricItem.getProductText();
                int matchLevel = this.validateRegex(domainPattern, domain);
                if (matchLevel <= 0) continue;
                String metric = metricItem.getMetricItemText();
                this.addRuleToMap(rule, metric, matchLevel, rules);
            }
        }
        return this.extractConfigs(domain, rules);
    }
}

