/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.sender;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.report.alert.AlertType;
import com.dianping.cat.report.alert.sender.AlertChannel;
import com.dianping.cat.report.alert.sender.AlertEntity;
import com.dianping.cat.report.alert.sender.AlertManager;
import com.dianping.cat.report.alert.sender.AlertMessageEntity;
import com.dianping.cat.report.alert.sender.config.AlertPolicyManager;
import com.dianping.cat.report.alert.sender.decorator.DecoratorManager;
import com.dianping.cat.report.alert.sender.receiver.ContactorManager;
import com.dianping.cat.report.alert.sender.sender.SenderManager;
import com.dianping.cat.report.alert.sender.spliter.SpliterManager;
import com.dianping.cat.report.alert.service.AlertEntityService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.regex.Pattern;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.tuple.Pair;

public class AlertManager
implements Initializable {
    @Inject
    private AlertPolicyManager m_policyManager;
    @Inject
    private DecoratorManager m_decoratorManager;
    @Inject
    private ContactorManager m_contactorManager;
    @Inject
    protected SpliterManager m_splitterManager;
    @Inject
    protected SenderManager m_senderManager;
    @Inject
    protected AlertEntityService m_alertEntityService;
    @Inject
    private ServerConfigManager m_configManager;
    private static final int MILLIS1MINUTE = 60000;
    private BlockingQueue<AlertEntity> m_alerts = new LinkedBlockingDeque(10000);
    private Map<String, AlertEntity> m_unrecoveredAlerts = new ConcurrentHashMap(1000);
    private Map<String, AlertEntity> m_sendedAlerts = new ConcurrentHashMap(1000);

    public boolean addAlert(AlertEntity alert) {
        String type = alert.getType();
        String group = alert.getGroup();
        Cat.logEvent((String)("Alert:" + type), (String)group, (String)"0", (String)alert.toString());
        if (this.m_configManager.isAlertMachine()) {
            return this.m_alerts.offer(alert);
        }
        return true;
    }

    private String generateTypeStr(String type) {
        AlertType typeByName = AlertType.getTypeByName((String)type);
        switch (1.$SwitchMap$com$dianping$cat$report$alert$AlertType[typeByName.ordinal()]) {
            case 1: {
                return "\u4e1a\u52a1\u544a\u8b66";
            }
            case 2: {
                return "\u7f51\u7edc\u544a\u8b66";
            }
            case 3: {
                return "\u7cfb\u7edf\u544a\u8b66";
            }
            case 4: {
                return "\u5f02\u5e38\u544a\u8b66";
            }
            case 5: {
                return "\u7b2c\u4e09\u65b9\u544a\u8b66";
            }
            case 6: {
                return "\u524d\u7aef\u544a\u8b66";
            }
            case 7: {
                return "\u624b\u673a\u7aef\u544a\u8b66";
            }
            case 8: {
                return "web\u544a\u8b66";
            }
            case 9: {
                return "\u5fc3\u8df3\u544a\u8b66";
            }
            case 10: {
                return "Transaction\u544a\u8b66";
            }
            case 11: {
                return "Event\u544a\u8b66";
            }
            case 12: {
                return "\u6570\u636e\u5e93\u7cfb\u7edf\u544a\u8b66";
            }
            case 13: {
                return "\u6570\u636e\u5e93\u8bbf\u95ee\u544a\u8b66";
            }
            case 14: {
                return "\u7f13\u5b58\u8bbf\u95ee\u544a\u8b66";
            }
        }
        return type;
    }

    public void initialize() throws InitializationException {
        Threads.forGroup((String)"cat").start((Runnable)new SendExecutor(this, null));
        Threads.forGroup((String)"cat").start((Runnable)new RecoveryAnnouncer(this, null));
    }

    public boolean isSuspend(String alertKey, int suspendMinute) {
        long duration;
        AlertEntity sendedAlert = (AlertEntity)this.m_sendedAlerts.get(alertKey);
        if (sendedAlert != null && (duration = System.currentTimeMillis() - sendedAlert.getDate().getTime()) / 60000L < (long)suspendMinute) {
            Cat.logEvent((String)"SuspendAlert", (String)alertKey, (String)"0", null);
            return true;
        }
        return false;
    }

    private boolean send(AlertEntity alert) {
        boolean result = false;
        String type = alert.getType();
        String group = alert.getGroup();
        String level = alert.getLevel();
        String alertKey = alert.getKey();
        List channels = this.m_policyManager.queryChannels(type, group, level);
        int suspendMinute = this.m_policyManager.querySuspendMinute(type, group, level);
        this.m_unrecoveredAlerts.put(alertKey, alert);
        Pair pair = this.m_decoratorManager.generateTitleAndContent(alert);
        String title = (String)pair.getKey();
        if (suspendMinute > 0) {
            if (this.isSuspend(alertKey, suspendMinute)) {
                return true;
            }
            this.m_sendedAlerts.put(alertKey, alert);
        }
        AlertMessageEntity message = null;
        for (AlertChannel channel : channels) {
            List receivers;
            String content;
            String rawContent = (String)pair.getValue();
            if (suspendMinute > 0) {
                rawContent = rawContent + "[\u544a\u8b66\u95f4\u9694\u65f6\u95f4] " + suspendMinute + " \u5206\u949f";
            }
            if (!this.m_senderManager.sendAlert(channel, message = new AlertMessageEntity(group, title, type, content = this.m_splitterManager.process(rawContent, channel), receivers = this.m_contactorManager.queryReceivers(alert.getContactGroup(), channel, type)))) continue;
            result = true;
        }
        String dbContent = Pattern.compile("<div.*(?=</div>)</div>", 32).matcher((CharSequence)pair.getValue()).replaceAll("");
        if (message == null) {
            message = new AlertMessageEntity(group, title, type, "", null);
        }
        message.setContent(dbContent);
        this.m_alertEntityService.storeAlert(alert, message);
        return result;
    }

    static /* synthetic */ AlertPolicyManager access$200(AlertManager x0) {
        return x0.m_policyManager;
    }

    static /* synthetic */ Map access$300(AlertManager x0) {
        return x0.m_unrecoveredAlerts;
    }

    static /* synthetic */ BlockingQueue access$400(AlertManager x0) {
        return x0.m_alerts;
    }

    static /* synthetic */ boolean access$500(AlertManager x0, AlertEntity x1) {
        return x0.send(x1);
    }
}

