/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.sender.config;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.alert.policy.entity.AlertPolicy;
import com.dianping.cat.home.alert.policy.entity.Group;
import com.dianping.cat.home.alert.policy.entity.Level;
import com.dianping.cat.home.alert.policy.entity.Type;
import com.dianping.cat.home.alert.policy.transform.DefaultSaxParser;
import com.dianping.cat.report.alert.sender.AlertChannel;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertPolicyManager
implements Initializable {
    @Inject
    private ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    private int m_configId;
    private AlertPolicy m_config;
    private static final String CONFIG_NAME = "alertPolicy";
    private static final String DEFAULT_TYPE = "default";
    private static final String DEFAULT_GROUP = "default";

    public AlertPolicy getAlertPolicy() {
        return this.m_config;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_config = DefaultSaxParser.parse((String)content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse((String)content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_config == null) {
            this.m_config = new AlertPolicy();
        }
    }

    public boolean insert(String xml) {
        try {
            this.m_config = DefaultSaxParser.parse((String)xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public List<AlertChannel> queryChannels(String typeName, String groupName, String levelName) {
        try {
            Level level = this.queryLevel(typeName, groupName, levelName);
            if (level == null) {
                return new ArrayList<AlertChannel>();
            }
            String send = level.getSend();
            String[] sends = send.split(",");
            ArrayList<AlertChannel> channels = new ArrayList<AlertChannel>();
            for (String str : sends) {
                AlertChannel channel = AlertChannel.findByName((String)str);
                if (channel == null) continue;
                channels.add(channel);
            }
            return channels;
        }
        catch (Exception ex) {
            return new ArrayList<AlertChannel>();
        }
    }

    private Level queryLevel(String typeName, String groupName, String levelName) {
        Group group;
        Type type = this.m_config.findType(typeName);
        if (type == null) {
            type = this.m_config.findType("default");
        }
        if ((group = type.findGroup(groupName)) == null) {
            group = type.findGroup("default");
        }
        return group.findLevel(levelName);
    }

    public int queryRecoverMinute(String typeName, String groupName, String levelName) {
        try {
            Level level = this.queryLevel(typeName, groupName, levelName);
            if (level == null) {
                return 1;
            }
            return level.getRecoverMinute();
        }
        catch (Exception ex) {
            return 1;
        }
    }

    public int querySuspendMinute(String typeName, String groupName, String levelName) {
        try {
            Level level = this.queryLevel(typeName, groupName, levelName);
            if (level == null) {
                return 0;
            }
            return level.getSuspendMinute();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        AlertPolicyManager alertPolicyManager = this;
        synchronized (alertPolicyManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.m_config.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }
}

