/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.sender.config;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.sender.entity.Par;
import com.dianping.cat.home.sender.entity.Sender;
import com.dianping.cat.home.sender.entity.SenderConfig;
import com.dianping.cat.home.sender.transform.DefaultSaxParser;
import java.util.List;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.StringUtils;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;

public class SenderConfigManager
implements Initializable {
    @Inject
    private ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    private int m_configId;
    private SenderConfig m_senderConfig;
    private static final String CONFIG_NAME = "senderConfig";

    public SenderConfig getConfig() {
        return this.m_senderConfig;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_senderConfig = DefaultSaxParser.parse((String)content);
            this.m_configId = config.getId();
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_senderConfig = DefaultSaxParser.parse((String)content);
                this.m_configId = config.getId();
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_senderConfig == null) {
            this.m_senderConfig = new SenderConfig();
        }
    }

    public boolean insert(String xml) {
        try {
            this.m_senderConfig = DefaultSaxParser.parse((String)xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean insert(Sender sender) {
        this.m_senderConfig.getSenders().put(sender.getId(), sender);
        return this.storeConfig();
    }

    public boolean remove(String id) {
        this.m_senderConfig.removeSender(id);
        return this.storeConfig();
    }

    public Sender querySender(String id) {
        return (Sender)this.m_senderConfig.getSenders().get(id);
    }

    public String queryParString(Sender sender) {
        List pars = sender.getPars();
        Object[] s = new String[pars.size()];
        int i = 0;
        for (Par par : pars) {
            s[i++] = par.getId();
        }
        return StringUtils.join((Object[])s, (String)"&");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        SenderConfigManager senderConfigManager = this;
        synchronized (senderConfigManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.m_senderConfig.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }
}

