/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.sender.decorator;

import com.dianping.cat.Cat;
import com.dianping.cat.report.alert.AlertType;
import com.dianping.cat.report.alert.sender.AlertEntity;
import com.dianping.cat.report.alert.sender.decorator.Decorator;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class EventDecorator
extends Decorator
implements Initializable {
    public static final String ID = AlertType.Event.getName();
    protected DateFormat m_linkFormat = new SimpleDateFormat("yyyyMMddHH");
    public Configuration m_configuration;

    public String generateContent(AlertEntity alert) {
        HashMap<String, String> datas = new HashMap<String, String>();
        String[] fields = alert.getMetric().split("-");
        datas.put("domain", alert.getGroup());
        datas.put("type", fields[0]);
        datas.put("name", fields[1]);
        datas.put("content", alert.getContent());
        datas.put("date", this.m_format.format(alert.getDate()));
        datas.put("linkDate", this.m_linkFormat.format(alert.getDate()));
        StringWriter sw = new StringWriter(5000);
        try {
            Template t = this.m_configuration.getTemplate("eventAlert.ftl");
            t.process(datas, (Writer)sw);
        }
        catch (Exception e) {
            Cat.logError((String)("build front end content error:" + alert.toString()), (Throwable)e);
        }
        return sw.toString();
    }

    public String generateTitle(AlertEntity alert) {
        StringBuilder sb = new StringBuilder();
        sb.append("[CAT Event\u544a\u8b66] [\u9879\u76ee: ").append(alert.getGroup()).append("] [\u76d1\u63a7\u9879: ").append(alert.getMetric()).append("]");
        return sb.toString();
    }

    public String getId() {
        return ID;
    }

    public void initialize() throws InitializationException {
        this.m_configuration = new Configuration();
        this.m_configuration.setDefaultEncoding("UTF-8");
        try {
            this.m_configuration.setClassForTemplateLoading(this.getClass(), "/freemaker");
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }
}

