/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.sender.decorator;

import com.dianping.cat.Cat;
import com.dianping.cat.report.alert.AlertType;
import com.dianping.cat.report.alert.sender.AlertEntity;
import com.dianping.cat.report.alert.sender.decorator.ProjectDecorator;
import com.dianping.cat.report.alert.summary.AlertSummaryExecutor;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionDecorator
extends ProjectDecorator
implements Initializable {
    @Inject
    private AlertSummaryExecutor m_executor;
    public Configuration m_configuration;
    public static final String ID = AlertType.Exception.getName();
    protected DateFormat m_linkFormat = new SimpleDateFormat("yyyyMMddHH");

    public String generateContent(AlertEntity alert) {
        Map dataMap = this.generateExceptionMap(alert);
        StringWriter sw = new StringWriter(5000);
        try {
            Template t = this.m_configuration.getTemplate("exceptionAlert.ftl");
            t.process((Object)dataMap, (Writer)sw);
        }
        catch (Exception e) {
            Cat.logError((String)("build exception content error:" + alert.toString()), (Throwable)e);
        }
        String alertContent = sw.toString();
        String summaryContext = "";
        try {
            summaryContext = this.m_executor.execute(alert.getGroup(), alert.getDate());
        }
        catch (Exception e) {
            Cat.logError((String)alert.toString(), (Throwable)e);
        }
        if (summaryContext != null) {
            return alertContent + "\n" + summaryContext;
        }
        return alertContent;
    }

    protected Map<Object, Object> generateExceptionMap(AlertEntity alert) {
        String domain = alert.getGroup();
        String contactInfo = this.buildContactInfo(domain);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("domain", domain);
        map.put("content", alert.getContent());
        map.put("date", this.m_format.format(alert.getDate()));
        map.put("linkDate", this.m_linkFormat.format(alert.getDate()));
        map.put("contactInfo", contactInfo);
        return map;
    }

    public String generateTitle(AlertEntity alert) {
        StringBuilder sb = new StringBuilder();
        sb.append("[CAT\u5f02\u5e38\u544a\u8b66] [\u9879\u76ee: ").append(alert.getGroup()).append("]");
        return sb.toString();
    }

    public String getId() {
        return ID;
    }

    public void initialize() throws InitializationException {
        this.m_configuration = new Configuration();
        this.m_configuration.setDefaultEncoding("UTF-8");
        try {
            this.m_configuration.setClassForTemplateLoading(this.getClass(), "/freemaker");
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }
}

