/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.sender.decorator;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.Project;
import com.dianping.cat.report.alert.sender.decorator.Decorator;
import com.dianping.cat.service.ProjectService;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;

public abstract class ProjectDecorator
extends Decorator {
    @Inject
    protected ProjectService m_projectService;

    public String buildContactInfo(String domainName) {
        try {
            Project project = this.m_projectService.findByDomain(domainName);
            if (project != null) {
                String owners = project.getOwner();
                String phones = project.getPhone();
                StringBuilder builder = new StringBuilder();
                if (!StringUtils.isEmpty((String)owners)) {
                    builder.append("[\u4e1a\u52a1\u8d1f\u8d23\u4eba: ").append(owners).append(" ]");
                }
                if (!StringUtils.isEmpty((String)phones)) {
                    builder.append("[\u8d1f\u8d23\u4eba\u624b\u673a\u53f7\u7801: ").append(phones).append(" ]");
                }
                return builder.toString();
            }
        }
        catch (Exception ex) {
            Cat.logError((String)("build project contact info error for domain: " + domainName), (Throwable)ex);
        }
        return "";
    }
}

