/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.sender.decorator;

import com.dianping.cat.Cat;
import com.dianping.cat.report.alert.AlertType;
import com.dianping.cat.report.alert.sender.AlertEntity;
import com.dianping.cat.report.alert.sender.decorator.ProjectDecorator;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThirdpartyDecorator
extends ProjectDecorator
implements Initializable {
    public Configuration m_configuration;
    public static final String ID = AlertType.ThirdParty.getName();
    protected DateFormat m_linkFormat = new SimpleDateFormat("yyyyMMddHH");

    public String generateContent(AlertEntity alert) {
        Map dataMap = this.generateExceptionMap(alert);
        StringWriter sw = new StringWriter(5000);
        try {
            Template t = this.m_configuration.getTemplate("thirdpartyAlert.ftl");
            t.process((Object)dataMap, (Writer)sw);
        }
        catch (Exception e) {
            Cat.logError((String)("build third party content error:" + alert.toString()), (Throwable)e);
        }
        return sw.toString();
    }

    private Map<Object, Object> generateExceptionMap(AlertEntity alert) {
        String domain = alert.getGroup();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("domain", domain);
        map.put("content", alert.getContent());
        map.put("date", this.m_format.format(alert.getDate()));
        map.put("linkDate", this.m_linkFormat.format(alert.getDate()));
        return map;
    }

    public String generateTitle(AlertEntity alert) {
        StringBuilder sb = new StringBuilder();
        sb.append("[CAT\u7b2c\u4e09\u65b9\u544a\u8b66] [\u9879\u76ee: ").append(alert.getGroup()).append("]");
        return sb.toString();
    }

    public String getId() {
        return ID;
    }

    public void initialize() throws InitializationException {
        this.m_configuration = new Configuration();
        this.m_configuration.setDefaultEncoding("UTF-8");
        try {
            this.m_configuration.setClassForTemplateLoading(this.getClass(), "/freemaker");
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }
}

