/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.sender.receiver;

import com.dianping.cat.core.dal.Project;
import com.dianping.cat.home.alert.config.entity.Receiver;
import com.dianping.cat.report.alert.sender.config.AlertConfigManager;
import com.dianping.cat.report.alert.sender.receiver.Contactor;
import com.dianping.cat.report.alert.sender.receiver.DefaultContactor;
import com.dianping.cat.service.ProjectService;
import java.util.ArrayList;
import java.util.List;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectContactor
extends DefaultContactor
implements Contactor {
    @Inject
    protected ProjectService m_projectService;
    @Inject
    protected AlertConfigManager m_configManager;

    public List<String> queryEmailContactors(String id) {
        Project project;
        ArrayList<String> mailReceivers = new ArrayList<String>();
        Receiver receiver = this.m_configManager.queryReceiverById(this.getId());
        if (receiver != null && !receiver.isEnable()) {
            return mailReceivers;
        }
        mailReceivers.addAll(this.buildDefaultMailReceivers(receiver));
        if (StringUtils.isNotEmpty((String)id) && (project = this.m_projectService.findByDomain(id)) != null) {
            mailReceivers.addAll(this.split(project.getEmail()));
        }
        return mailReceivers;
    }

    public List<String> querySmsContactors(String id) {
        Project project;
        ArrayList<String> smsReceivers = new ArrayList<String>();
        Receiver receiver = this.m_configManager.queryReceiverById(this.getId());
        if (receiver != null && !receiver.isEnable()) {
            return smsReceivers;
        }
        smsReceivers.addAll(this.buildDefaultSMSReceivers(receiver));
        if (StringUtils.isNotEmpty((String)id) && (project = this.m_projectService.findByDomain(id)) != null) {
            smsReceivers.addAll(this.split(project.getPhone()));
        }
        return smsReceivers;
    }

    public List<String> queryWeiXinContactors(String id) {
        Project project;
        ArrayList<String> weixinReceivers = new ArrayList<String>();
        Receiver receiver = this.m_configManager.queryReceiverById(this.getId());
        if (receiver != null && !receiver.isEnable()) {
            return weixinReceivers;
        }
        weixinReceivers.addAll(this.buildDefaultWeixinReceivers(receiver));
        if (StringUtils.isNotEmpty((String)id) && (project = this.m_projectService.findByDomain(id)) != null) {
            weixinReceivers.addAll(this.split(project.getEmail()));
        }
        return weixinReceivers;
    }
}

