/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.sender.sender;

import com.alibaba.fastjson.JSON;
import com.dianping.cat.Cat;
import com.dianping.cat.home.sender.entity.Par;
import com.dianping.cat.home.sender.entity.Sender;
import com.dianping.cat.report.alert.sender.AlertChannel;
import com.dianping.cat.report.alert.sender.AlertMessageEntity;
import com.dianping.cat.report.alert.sender.sender.AbstractSender;
import com.dianping.cat.report.alert.sender.sender.DingdingReturnJson;
import com.dianping.cat.report.alert.sender.sender.Message;
import com.dianping.cat.report.alert.sender.sender.MessageParam;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DingdingSender
extends AbstractSender {
    public static final String ID = AlertChannel.DINGDING.getName();

    public String getId() {
        return ID;
    }

    public boolean send(AlertMessageEntity message) {
        Sender sender = this.querySender();
        boolean batchSend = sender.getBatchSend();
        boolean result = false;
        if (batchSend) {
            String phones = message.getReceiverString();
            result = this.sendDingding(message, phones, sender);
        } else {
            List phones = message.getReceivers();
            for (String phone : phones) {
                boolean success = this.sendDingding(message, phone, sender);
                result = result || success;
            }
        }
        return result;
    }

    private boolean sendDingding(AlertMessageEntity message, String receiver, Sender sender) {
        boolean sendFlag = false;
        try {
            String title = message.getTitle();
            String content = message.getContent().replaceAll("\u5f02\u5e38\u540d\u79f0: Total", "\u5f02\u5e38\u540d\u79f0: \u6240\u6709\u5f02\u5e38");
            if ("business".equalsIgnoreCase(message.getType())) {
                content = title + content;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            List pars = sender.getPars();
            for (Par par : pars) {
                String[] array = par.getId().split("=");
                paramMap.put(array[0], array[1]);
            }
            String accessToken = this.getAccessToken((String)paramMap.get("corpid"), (String)paramMap.get("corpsecret"));
            if (StringUtils.isNotBlank((String)accessToken)) {
                StringBuilder urlStr = new StringBuilder();
                urlStr.append(sender.getUrl()).append("?access_token=").append(accessToken);
                String urlPrefix = urlStr.toString();
                String postContext = this.getPostContext(paramMap, content);
                sendFlag = this.dingdingHttpPost(urlPrefix, postContext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Cat.logError((Throwable)e);
        }
        return sendFlag;
    }

    private String getPostContext(Map<String, String> map, String content) {
        MessageParam param = new MessageParam();
        param.setChatid(map.get("chatid"));
        param.setSender(map.get("sender"));
        Message messageBody = new Message();
        messageBody.setContent(content);
        param.setText(messageBody);
        return JSON.toJSONString((Object)param);
    }

    private String getAccessToken(String corpid, String corpsecret) {
        String accessToken = "";
        if (StringUtils.isNotBlank((String)corpid) && StringUtils.isNotBlank((String)corpsecret)) {
            StringBuilder sb = new StringBuilder();
            sb.append("https://oapi.dingtalk.com/gettoken?").append("corpid=").append(corpid).append("&corpsecret=").append(corpsecret);
            DingdingReturnJson json = this.dingdingHttpGet(sb.toString());
            if (json != null && "0".equals(json.getErrcode()) && "ok".equalsIgnoreCase(json.getErrmsg())) {
                accessToken = json.getAccess_token();
            }
        }
        return accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DingdingReturnJson dingdingHttpGet(String urlPrefix) {
        URL url = null;
        InputStream in = null;
        URLConnection conn = null;
        DingdingReturnJson returnDomain = null;
        try {
            url = new URL(urlPrefix);
            conn = url.openConnection();
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(3000);
            in = conn.getInputStream();
            String returnStr = this.convertStreamToString(in);
            returnDomain = (DingdingReturnJson)JSON.parseObject((String)returnStr, DingdingReturnJson.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return returnDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dingdingHttpPost(String urlPrefix, String content) {
        InputStream in = null;
        FilterOutputStream writer = null;
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlPrefix);
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(3000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            conn.connect();
            writer = new DataOutputStream(conn.getOutputStream());
            writer.write(content.getBytes("UTF-8"));
            ((DataOutputStream)writer).flush();
            in = conn.getInputStream();
            String returnStr = this.convertStreamToString(in);
            DingdingReturnJson returnDomain = (DingdingReturnJson)JSON.parseObject((String)returnStr, DingdingReturnJson.class);
            if ("0".equals(returnDomain.getErrcode()) && "ok".equalsIgnoreCase(returnDomain.getErrmsg())) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            Cat.logError((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (writer != null) {
                    writer.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(new String(line.getBytes(), "utf-8"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }
}

