/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.sender.sender;

import com.dianping.cat.Cat;
import com.dianping.cat.home.sender.entity.Sender;
import com.dianping.cat.report.alert.sender.AlertChannel;
import com.dianping.cat.report.alert.sender.AlertMessageEntity;
import com.dianping.cat.report.alert.sender.sender.AbstractSender;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class MailSender
extends AbstractSender {
    public static final String ID = AlertChannel.MAIL.getName();

    public String getId() {
        return ID;
    }

    public boolean send(AlertMessageEntity message) {
        Sender sender = this.querySender();
        boolean batchSend = sender.isBatchSend();
        boolean result = false;
        if (batchSend) {
            String emails = message.getReceiverString();
            result = this.sendEmail(message, emails, sender);
        } else {
            List emails = message.getReceivers();
            for (String email : emails) {
                boolean success = this.sendEmail(message, email, sender);
                result = result || success;
            }
        }
        return result;
    }

    private boolean sendEmail(AlertMessageEntity message, String receiver, Sender sender) {
        String title = message.getTitle().replaceAll(",", " ");
        String content = message.getContent().replaceAll(",", " ");
        String urlPrefix = sender.getUrl();
        String urlPars = this.m_senderConfigManager.queryParString(sender);
        String time = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
        try {
            urlPars = urlPars.replace("${receiver}", receiver).replace("${title}", URLEncoder.encode(title, "utf-8")).replace("${content}", URLEncoder.encode(content, "utf-8")).replace("${time}", URLEncoder.encode(time, "utf-8"));
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return this.httpSend(sender.getSuccessCode(), sender.getType(), urlPrefix, urlPars);
    }
}

