/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.sender.sender;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.report.alert.sender.AlertChannel;
import com.dianping.cat.report.alert.sender.AlertMessageEntity;
import com.dianping.cat.report.alert.sender.sender.Sender;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;

public class SenderManager
extends ContainerHolder
implements Initializable {
    @Inject
    private ServerConfigManager m_configManager;
    private Map<String, Sender> m_senders = new HashMap();

    public void initialize() throws InitializationException {
        this.m_senders = this.lookupMap(Sender.class);
    }

    public boolean sendAlert(AlertChannel channel, AlertMessageEntity message) {
        String channelName = channel.getName();
        try {
            boolean result = true;
            String str = "nosend";
            if (this.m_configManager.isSendMachine()) {
                Sender sender = (Sender)this.m_senders.get(channelName);
                result = sender.send(message);
                str = String.valueOf(result);
            }
            Cat.logEvent((String)("Channel:" + channelName), (String)(message.getType() + ":" + str), (String)"0", null);
            return result;
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }
}

