/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.sender.sender;

import com.dianping.cat.Cat;
import com.dianping.cat.home.sender.entity.Sender;
import com.dianping.cat.report.alert.sender.AlertChannel;
import com.dianping.cat.report.alert.sender.AlertMessageEntity;
import com.dianping.cat.report.alert.sender.sender.AbstractSender;
import java.net.URLEncoder;
import java.util.List;

public class SmsSender
extends AbstractSender {
    public static final String ID = AlertChannel.SMS.getName();

    public String getId() {
        return ID;
    }

    public boolean send(AlertMessageEntity message) {
        Sender sender = this.querySender();
        boolean batchSend = sender.getBatchSend();
        boolean result = false;
        if (batchSend) {
            String phones = message.getReceiverString();
            result = this.sendSms(message, phones, sender);
        } else {
            List phones = message.getReceivers();
            for (String phone : phones) {
                boolean success = this.sendSms(message, phone, sender);
                result = result || success;
            }
        }
        return result;
    }

    private boolean sendSms(AlertMessageEntity message, String receiver, Sender sender) {
        String filterContent = message.getContent().replaceAll("(<a href.*(?=</a>)</a>)|(\n)", "");
        String content = message.getTitle() + " " + filterContent;
        String urlPrefix = sender.getUrl();
        String urlPars = this.m_senderConfigManager.queryParString(sender);
        try {
            urlPars = urlPars.replace("${receiver}", URLEncoder.encode(receiver, "utf-8")).replace("${content}", URLEncoder.encode(content, "utf-8"));
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return this.httpSend(sender.getSuccessCode(), sender.getType(), urlPrefix, urlPars);
    }
}

