/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.sender.sender;

import com.dianping.cat.Cat;
import com.dianping.cat.home.sender.entity.Sender;
import com.dianping.cat.report.alert.sender.AlertChannel;
import com.dianping.cat.report.alert.sender.AlertMessageEntity;
import com.dianping.cat.report.alert.sender.sender.AbstractSender;
import java.net.URLEncoder;
import java.util.List;

public class WeixinSender
extends AbstractSender {
    public static final String ID = AlertChannel.WEIXIN.getName();

    public String getId() {
        return ID;
    }

    public boolean send(AlertMessageEntity message) {
        Sender sender = this.querySender();
        boolean batchSend = sender.getBatchSend();
        boolean result = false;
        if (batchSend) {
            String weixins = message.getReceiverString();
            result = this.sendWeixin(message, weixins, sender);
        } else {
            List weixins = message.getReceivers();
            for (String weixin : weixins) {
                boolean success = this.sendWeixin(message, weixin, sender);
                result = result || success;
            }
        }
        return result;
    }

    private boolean sendWeixin(AlertMessageEntity message, String receiver, Sender sender) {
        String domain = message.getGroup();
        String title = message.getTitle().replaceAll(",", " ");
        String content = message.getContent().replaceAll(",", " ").replaceAll("<a href.*(?=</a>)</a>", "");
        String urlPrefix = sender.getUrl();
        String urlPars = this.m_senderConfigManager.queryParString(sender);
        try {
            urlPars = urlPars.replace("${domain}", URLEncoder.encode(domain, "utf-8")).replace("${receiver}", URLEncoder.encode(receiver, "utf-8")).replace("${title}", URLEncoder.encode(title, "utf-8")).replace("${content}", URLEncoder.encode(content, "utf-8")).replace("${type}", URLEncoder.encode(message.getType(), "utf-8"));
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return this.httpSend(sender.getSuccessCode(), sender.getType(), urlPrefix, urlPars);
    }
}

