/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.storage;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.storage.model.entity.Operation;
import com.dianping.cat.consumer.storage.model.entity.Segment;
import com.dianping.cat.consumer.storage.model.entity.StorageReport;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.home.rule.entity.Config;
import com.dianping.cat.home.rule.entity.Rule;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.alert.AlertResultEntity;
import com.dianping.cat.report.alert.DataChecker;
import com.dianping.cat.report.alert.sender.AlertEntity;
import com.dianping.cat.report.alert.sender.AlertManager;
import com.dianping.cat.report.alert.storage.AbstractStorageAlert;
import com.dianping.cat.report.alert.storage.StorageRuleConfigManager;
import com.dianping.cat.report.page.storage.config.StorageGroupConfigManager;
import com.dianping.cat.report.page.storage.topology.StorageAlertInfoBuilder;
import com.dianping.cat.report.page.storage.transform.StorageMergeHelper;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStorageAlert
implements Threads.Task,
LogEnabled {
    @Inject(type=ModelService.class, value={"storage"})
    private ModelService<StorageReport> m_service;
    @Inject
    private StorageMergeHelper m_reportMergeHelper;
    @Inject
    protected DataChecker m_dataChecker;
    @Inject
    protected AlertManager m_alertManager;
    @Inject
    protected StorageGroupConfigManager m_storageConfigManager;
    @Inject
    protected StorageAlertInfoBuilder m_alertBuilder;
    protected Logger m_logger;
    private static final int DATA_AREADY_MINUTE = 1;
    protected static final long DURATION = 60000L;

    private double[] buildArrayData(int start, int end, ReportFetcherParam param, StorageReport report) {
        String machine = param.getMachine();
        String target = param.getTarget();
        String method = param.getMethod();
        Operation op = report.findOrCreateMachine(machine).findOrCreateDomain("All").findOrCreateOperation(method);
        Map segments = op.getSegments();
        int length = end - start + 1;
        double[] datas = new double[60];
        double[] result = new double[length];
        if ("count".equalsIgnoreCase(target)) {
            for (Map.Entry entry : segments.entrySet()) {
                datas[((Integer)entry.getKey()).intValue()] = ((Segment)entry.getValue()).getCount();
            }
        } else if ("long".equalsIgnoreCase(target)) {
            for (Map.Entry entry : segments.entrySet()) {
                datas[((Integer)entry.getKey()).intValue()] = ((Segment)entry.getValue()).getLongCount();
            }
        } else if ("avg".equals(target)) {
            for (Map.Entry entry : segments.entrySet()) {
                datas[((Integer)entry.getKey()).intValue()] = ((Segment)entry.getValue()).getAvg();
            }
        } else if ("error".equals(target)) {
            for (Map.Entry entry : segments.entrySet()) {
                datas[((Integer)entry.getKey()).intValue()] = ((Segment)entry.getValue()).getError();
            }
        } else if ("errorPercent".equals(target)) {
            for (Map.Entry entry : segments.entrySet()) {
                long count = ((Segment)entry.getValue()).getCount();
                if (count > 0L) {
                    datas[((Integer)entry.getKey()).intValue()] = (double)((Segment)entry.getValue()).getError() / (double)count;
                    continue;
                }
                datas[((Integer)entry.getKey()).intValue()] = 0.0;
            }
        } else {
            Cat.logError((Throwable)new RuntimeException("Unrecognized storage databse alert target field: " + target));
        }
        System.arraycopy(datas, start, result, 0, length);
        return result;
    }

    protected int calAlreadyMinute() {
        long current = System.currentTimeMillis() / 1000L / 60L;
        int minute = (int)(current % 60L) - 1;
        return minute;
    }

    private List<AlertResultEntity> computeAlertForRule(int minute, ReportFetcherParam param, List<Config> configs, StorageReport report) {
        ArrayList<AlertResultEntity> results = new ArrayList<AlertResultEntity>();
        Pair conditionPair = this.getRuleConfigManager().convertConditions(configs);
        if (conditionPair != null) {
            int maxMinute = (Integer)conditionPair.getKey();
            List conditions = (List)conditionPair.getValue();
            if (minute >= maxMinute - 1) {
                if (report != null) {
                    int start = minute + 1 - maxMinute;
                    int end = minute;
                    double[] data = this.buildArrayData(start, end, param, report);
                    results.addAll(this.m_dataChecker.checkData(data, conditions));
                }
            } else if (minute < 0) {
                report = this.fetchStorageReport(param.getName(), ModelPeriod.LAST);
                if (report != null) {
                    int start = 60 + minute + 1 - maxMinute;
                    int end = 60 + minute;
                    double[] data = this.buildArrayData(start, end, param, report);
                    results.addAll(this.m_dataChecker.checkData(data, conditions));
                }
            } else {
                StorageReport lastReport = this.fetchStorageReport(param.getName(), ModelPeriod.LAST);
                if (report != null && lastReport != null) {
                    int currentStart = 0;
                    int currentEnd = minute;
                    double[] currentValue = this.buildArrayData(currentStart, currentEnd, param, report);
                    int lastStart = 61 - (maxMinute - minute);
                    int lastEnd = 59;
                    double[] lastValue = this.buildArrayData(lastStart, lastEnd, param, lastReport);
                    double[] data = this.mergeArray(lastValue, currentValue);
                    results.addAll(this.m_dataChecker.checkData(data, conditions));
                }
            }
        }
        return results;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private StorageReport fetchStorageReport(String name, ModelPeriod period) {
        ModelRequest request = new ModelRequest(name + "-" + this.getName(), period.getStartTime()).setProperty("ip", "All").setProperty("requireAll", "true");
        ModelResponse response = this.m_service.invoke(request);
        if (response != null) {
            StorageReport report = (StorageReport)response.getModel();
            return this.m_reportMergeHelper.mergeAllDomains(report, "All");
        }
        return null;
    }

    protected abstract StorageRuleConfigManager getRuleConfigManager();

    protected double[] mergeArray(double[] from, double[] to) {
        int i;
        int fromLength = from.length;
        int toLength = to.length;
        double[] result = new double[fromLength + toLength];
        int index = 0;
        for (i = 0; i < fromLength; ++i) {
            result[i] = from[i];
            ++index;
        }
        for (i = 0; i < toLength; ++i) {
            result[i + index] = to[i];
        }
        return result;
    }

    private void handleAlertInfos(ReportFetcherParam param, int minute, List<AlertResultEntity> alertResults) {
        for (AlertResultEntity alertResult : alertResults) {
            AlertEntity entity = new AlertEntity();
            entity.setDate(alertResult.getAlertTime()).setContent(alertResult.getContent()).setLevel(alertResult.getAlertLevel());
            entity.setMetric(param.toString()).setType(this.getName()).setGroup(param.getName());
            this.m_alertManager.addAlert(entity);
            this.m_alertBuilder.processAlertEntity(this.getName(), minute, entity, param);
        }
    }

    private void processStorage(String id) {
        StorageReport currentReport = this.fetchStorageReport(id, ModelPeriod.CURRENT);
        if (currentReport != null) {
            for (String ip : currentReport.getIps()) {
                if (!this.m_storageConfigManager.isSQLAlertMachine(id, ip, this.getName())) continue;
                this.processMachine(id, currentReport, ip);
            }
        }
    }

    private void processMachine(String id, StorageReport currentReport, String ip) {
        int minute = this.calAlreadyMinute();
        boolean alert = true;
        List rules = this.getRuleConfigManager().findRules(id, ip);
        ArrayList<Pair> alertEntities = new ArrayList<Pair>();
        for (Rule rule : rules) {
            List results;
            ReportFetcherParam param = new ReportFetcherParam(id, ip, rule.getId());
            if (param.getAnd()) {
                if (!alert) continue;
                results = this.computeAlertForRule(minute, param, rule.getConfigs(), currentReport);
                if (results.size() > 0) {
                    alertEntities.add(new Pair((Object)param, (Object)results));
                    continue;
                }
                alert = false;
                continue;
            }
            results = this.computeAlertForRule(minute, param, rule.getConfigs(), currentReport);
            this.handleAlertInfos(param, minute, results);
        }
        if (alert) {
            for (Pair entity : alertEntities) {
                this.handleAlertInfos((ReportFetcherParam)entity.getKey(), minute, (List)entity.getValue());
            }
        }
    }

    private Set<String> queryCurrentStorages() {
        StorageReport report;
        HashSet<String> ids = new HashSet<String>(this.m_storageConfigManager.queryStorageGroup(this.getName()).getStorages().keySet());
        ModelRequest request = new ModelRequest("*-" + this.getName(), ModelPeriod.CURRENT.getStartTime()).setProperty("ip", "All");
        ModelResponse response = this.m_service.invoke(request);
        if (response != null && (report = (StorageReport)response.getModel()) != null) {
            ids.addAll(report.getIds());
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean active = TimeHelper.sleepToNextMinute();
        while (active) {
            Transaction t = Cat.newTransaction((String)("Alert" + this.getName()), (String)TimeHelper.getMinuteStr());
            long current = System.currentTimeMillis();
            try {
                Set storages = this.queryCurrentStorages();
                for (String storage : storages) {
                    try {
                        this.processStorage(storage);
                    }
                    catch (Exception e) {
                        Cat.logError((Throwable)e);
                    }
                }
                t.setStatus("0");
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                Cat.logError((Throwable)e);
            }
            finally {
                t.complete();
            }
            long duration = System.currentTimeMillis() - current;
            try {
                if (duration >= 60000L) continue;
                Thread.sleep(60000L - duration);
            }
            catch (InterruptedException e) {
                active = false;
            }
        }
    }

    public void shutdown() {
    }
}

