/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.storage;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.rule.entity.MonitorRules;
import com.dianping.cat.home.rule.entity.Rule;
import com.dianping.cat.home.rule.transform.DefaultSaxParser;
import com.dianping.cat.report.alert.config.BaseRuleConfigManager;
import com.dianping.cat.report.alert.storage.StorageRuleConfigManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StorageRuleConfigManager
extends BaseRuleConfigManager
implements Initializable {
    @Inject
    private ContentFetcher m_fetcher;
    private Map<String, RuleMappingConfig> m_ruleMappings = new HashMap();

    protected abstract String getConfigName();

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(this.getConfigName(), ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_config = DefaultSaxParser.parse((String)content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(this.getConfigName());
                Config config = this.m_configDao.createLocal();
                config.setName(this.getConfigName());
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse((String)content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_config == null) {
            this.m_config = new MonitorRules();
        }
        this.refreshData();
    }

    private void refreshData() {
        Map rules = this.m_config.getRules();
        HashMap<String, RuleMappingConfig> mapping = new HashMap<String, RuleMappingConfig>();
        for (Map.Entry entry : rules.entrySet()) {
            String ruleId = ((Rule)entry.getValue()).getId();
            String[] conditions = ruleId.split(";");
            if (conditions.length >= 4) {
                String name = conditions[0];
                String machine = conditions[1];
                String operation = conditions[2];
                String attribute = conditions[3];
                RuleMappingConfig ruleMappingConfig = (RuleMappingConfig)mapping.get(name);
                if (ruleMappingConfig == null) {
                    ruleMappingConfig = new RuleMappingConfig(name);
                    mapping.put(name, ruleMappingConfig);
                }
                IpMappingConfig ip = ruleMappingConfig.findOrCreate(machine);
                OperationConfig op = ip.findOrCreate(operation);
                op.addRule(attribute, (Rule)entry.getValue());
                continue;
            }
            Cat.logError((Throwable)new RuntimeException("Unrecognized " + this.getConfigName() + " rule size != 4 : " + ruleId));
        }
        this.m_ruleMappings = mapping;
    }

    protected boolean storeConfig() {
        boolean success = super.storeConfig();
        if (success) {
            this.refreshData();
        }
        return success;
    }

    public List<Rule> findRules(String name, String machine) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        RuleMappingConfig ruleMapping = (RuleMappingConfig)this.m_ruleMappings.get(name);
        if (ruleMapping == null) {
            ruleMapping = (RuleMappingConfig)this.m_ruleMappings.get("All");
        }
        if (ruleMapping != null) {
            IpMappingConfig ipMapping = ruleMapping.find(machine);
            if (ipMapping == null) {
                ipMapping = ruleMapping.find("All");
            }
            if (ipMapping != null) {
                Map operations = ipMapping.getOperations();
                for (OperationConfig operation : operations.values()) {
                    rules.addAll(operation.getRules().values());
                }
            }
        }
        return rules;
    }
}

