/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.summary;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.alert.sender.AlertChannel;
import com.dianping.cat.report.alert.sender.AlertMessageEntity;
import com.dianping.cat.report.alert.sender.sender.SenderManager;
import com.dianping.cat.report.alert.summary.build.SummaryBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.unidal.helper.Splitters;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertSummaryExecutor {
    @Inject(type=SummaryBuilder.class, value={"AlertSummaryContentGenerator"})
    private SummaryBuilder m_relatedBuilder;
    @Inject(type=SummaryBuilder.class, value={"FailureDecorator"})
    private SummaryBuilder m_failureBuilder;
    @Inject(type=SummaryBuilder.class, value={"AlterationSummaryContentGenerator"})
    private SummaryBuilder m_alterationBuilder;
    @Inject
    private SenderManager m_sendManager;
    public static final long SUMMARY_DURATION = 300000L;
    public static final long ALTERATION_DURATION = 1800000L;

    private List<String> builderReceivers(String str) {
        ArrayList<String> result = new ArrayList<String>();
        if (str != null) {
            result.addAll(Splitters.by((String)",").noEmptyItem().split(str));
        }
        return result;
    }

    private String buildMailTitle(String domain, Date date) {
        StringBuilder builder = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        builder.append("[\u7edf\u4e00\u544a\u8b66] [\u9879\u76ee ").append(domain).append("]");
        builder.append("[\u65f6\u95f4 ").append(dateFormat.format(date)).append("]");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String domain, Date date) {
        Transaction t = Cat.newTransaction((String)"Summary", (String)domain);
        date = this.normalizeDate(date);
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(this.m_failureBuilder.generateHtml(domain, date));
            builder.append(this.m_alterationBuilder.generateHtml(domain, date));
            t.setStatus("0");
            String string = builder.toString();
            return string;
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
            Cat.logError((String)("generate alert summary fail:" + domain + " " + date), (Throwable)e);
        }
        finally {
            t.complete();
        }
        return null;
    }

    public String execute(String domain, Date date, String receiverStr) {
        String content = this.execute(domain, date);
        if (content == null || "".equals(content)) {
            return null;
        }
        String title = this.buildMailTitle(domain, date);
        List receivers = this.builderReceivers(receiverStr);
        AlertMessageEntity message = new AlertMessageEntity(domain, title, "alertSummary", content, receivers);
        if (receivers.size() > 0) {
            this.m_sendManager.sendAlert(AlertChannel.MAIL, message);
        }
        return content;
    }

    private Date normalizeDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

