/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.summary.build;

import com.dianping.cat.Cat;
import com.dianping.cat.home.alert.summary.entity.Alert;
import com.dianping.cat.home.alert.summary.entity.AlertSummary;
import com.dianping.cat.home.alert.summary.entity.Category;
import com.dianping.cat.home.dal.report.AlertDao;
import com.dianping.cat.home.dal.report.AlertEntity;
import com.dianping.cat.home.dependency.graph.entity.TopologyEdge;
import com.dianping.cat.home.dependency.graph.entity.TopologyGraph;
import com.dianping.cat.report.alert.AlertType;
import com.dianping.cat.report.page.dependency.graph.TopologyGraphManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertInfoBuilder {
    @Inject
    private AlertDao m_alertDao;
    @Inject
    private TopologyGraphManager m_topologyManager;
    public static final String LONG_CALL = "long_call";
    public static final String PREFIX = "dependency_";

    private Collection<Alert> convertToAlert(List<TopologyEdge> edges, Date date) {
        LinkedHashMap<String, Alert> alerts = new LinkedHashMap<String, Alert>();
        for (TopologyEdge edge : edges) {
            String domain = edge.getSelf();
            String metric = edge.getKey();
            String key = domain + ":" + metric;
            Alert alertInMap = (Alert)alerts.get(key);
            if (alertInMap == null) {
                Alert alert = new Alert();
                alert.setAlertTime(date);
                alert.setContext(edge.getDes());
                alert.setMetric(metric);
                alert.setType("slow " + edge.getType());
                alert.setDomain(domain);
                alert.setCount(Integer.valueOf(1));
                alerts.put(key, alert);
                continue;
            }
            int originCount = alertInMap.getCount();
            alertInMap.setCount(Integer.valueOf(originCount + 1));
        }
        return alerts.values();
    }

    private Collection<Alert> convertToAlerts(List<com.dianping.cat.home.dal.report.Alert> dbAlerts) {
        LinkedHashMap<String, Alert> alerts = new LinkedHashMap<String, Alert>();
        for (com.dianping.cat.home.dal.report.Alert dbAlert : dbAlerts) {
            String domain = dbAlert.getDomain();
            String metric = dbAlert.getMetric();
            String key = domain + ":" + metric;
            Alert alertInMap = (Alert)alerts.get(key);
            if (alertInMap == null) {
                Alert alert = new Alert();
                alert.setAlertTime(dbAlert.getAlertTime());
                alert.setContext(dbAlert.getContent());
                alert.setMetric(metric);
                alert.setType(dbAlert.getType());
                alert.setDomain(domain);
                alert.setCount(Integer.valueOf(1));
                alerts.put(key, alert);
                continue;
            }
            int originCount = alertInMap.getCount();
            alertInMap.setCount(Integer.valueOf(originCount + 1));
        }
        return alerts.values();
    }

    public AlertSummary generateAlertSummary(String domain, Date date) {
        AlertSummary alertSummary = new AlertSummary();
        alertSummary.setDomain(domain);
        alertSummary.setAlertDate(date);
        alertSummary.addCategory(this.generateCategoryByTimeCategory(date, AlertType.Network.getName()));
        alertSummary.addCategory(this.generateCategoryByTimeCateDomain(date, AlertType.Business.getName(), domain));
        alertSummary.addCategory(this.generateCategoryByTimeCateDomain(date, AlertType.Exception.getName(), domain));
        alertSummary.addCategory(this.generateCategoryByTimeCateDomain(date, AlertType.System.getName(), domain));
        TopologyGraph topology = this.m_topologyManager.buildTopologyGraph(domain, date.getTime());
        int statusThreshold = 2;
        alertSummary.addCategory(this.generateLongCallCategory(date, topology, statusThreshold));
        List dependencyDomains = this.queryDependencyDomains(topology, date, domain);
        alertSummary.addCategory(this.generateDependCategoryByTimeCateDomain(date, AlertType.Exception.getName(), dependencyDomains));
        return alertSummary;
    }

    private Category generateCategoryByTimeCateDomain(Date date, String cate, String domain) {
        Category category = new Category(cate);
        String dbCategoryName = cate;
        Date startTime = new Date(date.getTime() - 300000L);
        try {
            List dbAlerts = this.m_alertDao.queryAlertsByTimeCategoryDomain(startTime, date, dbCategoryName, domain, AlertEntity.READSET_FULL);
            this.setDBAlertsToCategory(category, dbAlerts);
        }
        catch (DalException e) {
            Cat.logError((String)("find alerts error for category:" + cate + " domain:" + domain + " date:" + date), (Throwable)e);
        }
        return category;
    }

    private Category generateCategoryByTimeCategory(Date date, String cate) {
        Category category = new Category(cate);
        String dbCategoryName = cate;
        Date startTime = new Date(date.getTime() - 300000L);
        try {
            List dbAlerts = this.m_alertDao.queryAlertsByTimeCategory(startTime, date, dbCategoryName, AlertEntity.READSET_FULL);
            this.setDBAlertsToCategory(category, dbAlerts);
        }
        catch (DalException e) {
            Cat.logError((String)("find alerts error for category:" + cate + " date:" + date), (Throwable)e);
        }
        return category;
    }

    private Category generateDependCategoryByTimeCateDomain(Date date, String cate, List<String> dependencyDomains) {
        String categoryName = PREFIX + cate;
        String dbCategoryName = cate;
        Category category = new Category(categoryName);
        Date startTime = new Date(date.getTime() - 300000L);
        for (String domain : dependencyDomains) {
            try {
                List dbAlerts = this.m_alertDao.queryAlertsByTimeCategoryDomain(startTime, date, dbCategoryName, domain, AlertEntity.READSET_FULL);
                this.setDBAlertsToCategory(category, dbAlerts);
            }
            catch (DalException e) {
                Cat.logError((String)("find dependency alerts error for category:" + cate + " domain:" + domain + " date:" + date), (Throwable)e);
            }
        }
        return category;
    }

    private Category generateLongCallCategory(Date date, TopologyGraph topology, int statusThreshold) {
        Category category = new Category(LONG_CALL);
        ArrayList<TopologyEdge> edges = new ArrayList<TopologyEdge>();
        for (TopologyEdge edge : topology.getEdges().values()) {
            if (edge.getStatus() < statusThreshold) continue;
            edges.add(edge);
        }
        Collection alerts = this.convertToAlert(edges, date);
        Iterator it = alerts.iterator();
        while (it.hasNext()) {
            category.addAlert((Alert)it.next());
        }
        return category;
    }

    private List<String> queryDependencyDomains(TopologyGraph topology, Date date, String domain) {
        ArrayList<String> domains = new ArrayList<String>();
        for (String dependencyDomain : topology.getNodes().keySet()) {
            domains.add(dependencyDomain);
        }
        return domains;
    }

    private void setDBAlertsToCategory(Category category, List<com.dianping.cat.home.dal.report.Alert> dbAlerts) {
        Collection alerts = this.convertToAlerts(dbAlerts);
        Iterator it = alerts.iterator();
        while (it.hasNext()) {
            category.addAlert((Alert)it.next());
        }
    }
}

