/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.thirdParty;

import com.dianping.cat.Cat;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.alert.AlertType;
import com.dianping.cat.report.alert.sender.AlertEntity;
import com.dianping.cat.report.alert.sender.AlertManager;
import com.dianping.cat.report.alert.thirdParty.ThirdPartyAlertEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThirdPartyAlert
implements Threads.Task {
    @Inject
    private AlertManager m_sendManager;
    private static final long DURATION = 60000L;
    private BlockingQueue<ThirdPartyAlertEntity> m_entities = new ArrayBlockingQueue(5000);

    private Map<String, List<ThirdPartyAlertEntity>> buildDomain2AlertMap(List<ThirdPartyAlertEntity> alertEntities) {
        HashMap<String, List<ThirdPartyAlertEntity>> domain2AlertMap = new HashMap<String, List<ThirdPartyAlertEntity>>();
        for (ThirdPartyAlertEntity entity : alertEntities) {
            String domain = entity.getDomain();
            ArrayList<ThirdPartyAlertEntity> alertList = (ArrayList<ThirdPartyAlertEntity>)domain2AlertMap.get(domain);
            if (alertList == null) {
                alertList = new ArrayList<ThirdPartyAlertEntity>();
                domain2AlertMap.put(domain, alertList);
            }
            alertList.add(entity);
        }
        return domain2AlertMap;
    }

    public String getName() {
        return AlertType.ThirdParty.getName();
    }

    public boolean put(ThirdPartyAlertEntity entity) {
        boolean result = true;
        try {
            boolean temp = this.m_entities.offer(entity, 5L, TimeUnit.MILLISECONDS);
            if (!temp) {
                result = temp;
            }
            return result;
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean active = TimeHelper.sleepToNextMinute();
        while (active) {
            Transaction t = Cat.newTransaction((String)"AlertThirdParty", (String)TimeHelper.getMinuteStr());
            long current = System.currentTimeMillis();
            try {
                ArrayList<ThirdPartyAlertEntity> alertEntities = new ArrayList<ThirdPartyAlertEntity>();
                while (this.m_entities.size() > 0) {
                    ThirdPartyAlertEntity entity = (ThirdPartyAlertEntity)this.m_entities.poll(5L, TimeUnit.MILLISECONDS);
                    alertEntities.add(entity);
                }
                Map domain2AlertMap = this.buildDomain2AlertMap(alertEntities);
                for (Map.Entry entry : domain2AlertMap.entrySet()) {
                    String domain = (String)entry.getKey();
                    List thirdPartyAlerts = (List)entry.getValue();
                    AlertEntity entity = new AlertEntity();
                    entity.setDate(new Date()).setContent(thirdPartyAlerts.toString()).setLevel("warning");
                    entity.setMetric(this.getName()).setType(this.getName()).setGroup(domain);
                    this.m_sendManager.addAlert(entity);
                }
                t.setStatus("0");
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                Cat.logError((Throwable)e);
            }
            finally {
                t.complete();
            }
            long duration = System.currentTimeMillis() - current;
            try {
                if (duration >= 60000L) continue;
                Thread.sleep(60000L - duration);
            }
            catch (InterruptedException e) {
                active = false;
            }
        }
    }

    public void shutdown() {
    }
}

