/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.thirdParty;

import com.dianping.cat.Cat;
import com.dianping.cat.home.alert.thirdparty.entity.Http;
import com.dianping.cat.home.alert.thirdparty.entity.Par;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.alert.thirdParty.HttpConnector;
import com.dianping.cat.report.alert.thirdParty.ThirdPartyAlert;
import com.dianping.cat.report.alert.thirdParty.ThirdPartyAlertBuilder;
import com.dianping.cat.report.alert.thirdParty.ThirdPartyAlertEntity;
import com.dianping.cat.report.alert.thirdParty.ThirdPartyConfigManager;
import java.util.List;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThirdPartyAlertBuilder
implements Threads.Task,
LogEnabled {
    @Inject
    private HttpConnector m_httpConnector;
    @Inject
    private ThirdPartyAlert m_thirdPartyAlert;
    @Inject
    private ThirdPartyConfigManager m_configManager;
    private static final long DURATION = 60000L;
    private Logger m_logger;

    private void buildAlertEntities(long current) {
        List https = this.m_configManager.queryHttps();
        for (Http http : https) {
            if (this.connectHttpUrl(http)) continue;
            Threads.forGroup((String)"cat").start((Runnable)new HttpReconnector(this, this, http, current + 60000L));
        }
    }

    public ThirdPartyAlertEntity buildAlertEntity(Http http) {
        ThirdPartyAlertEntity entity = new ThirdPartyAlertEntity();
        String url = http.getUrl();
        String type = http.getType();
        List pars = http.getPars();
        String details = "HTTP URL[" + url + "?" + this.buildPars(pars) + "] " + type.toUpperCase() + "\u8bbf\u95ee\u51fa\u73b0\u5f02\u5e38";
        entity.setDomain(http.getDomain()).setType(type).setDetails(details);
        return entity;
    }

    private String buildPars(List<Par> paras) {
        Object[] s = new String[paras.size()];
        int i = 0;
        for (Par entry : paras) {
            s[i++] = entry.getId();
        }
        return StringUtils.join((Object[])s, (String)"&");
    }

    public boolean connectHttpUrl(Http http) {
        boolean result = false;
        String type = http.getType();
        String url = http.getUrl();
        List paras = http.getPars();
        String joined = null;
        if (paras != null) {
            joined = this.buildPars(paras);
        }
        if ("get".equalsIgnoreCase(type)) {
            if (StringUtils.isNotEmpty((String)joined)) {
                url = url + "?" + joined;
            }
            result = this.m_httpConnector.readFromGet(url);
        } else if ("post".equalsIgnoreCase(type)) {
            result = this.m_httpConnector.readFromPost(url, joined);
        }
        return result;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public String getName() {
        return "thirdParty-alert-task";
    }

    public void putAlertEnity(ThirdPartyAlertEntity entity) {
        this.m_thirdPartyAlert.put(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean active = true;
        while (active) {
            long current = System.currentTimeMillis();
            Transaction t = Cat.newTransaction((String)"ReloadTask", (String)"AlertThirdPartyBuilder");
            try {
                this.buildAlertEntities(current);
                t.setStatus("0");
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                this.m_logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                t.complete();
            }
            long duration = System.currentTimeMillis() - current;
            try {
                if (duration >= 60000L) continue;
                Thread.sleep(60000L - duration);
            }
            catch (InterruptedException e) {
                active = false;
            }
        }
    }

    public void shutdown() {
    }
}

