/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.thirdParty;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.alert.thirdparty.entity.Http;
import com.dianping.cat.home.alert.thirdparty.entity.Par;
import com.dianping.cat.home.alert.thirdparty.entity.Socket;
import com.dianping.cat.home.alert.thirdparty.entity.ThirdPartyConfig;
import com.dianping.cat.home.alert.thirdparty.transform.DefaultSaxParser;
import java.util.List;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThirdPartyConfigManager
implements Initializable {
    @Inject
    private ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    private int m_configId;
    private ThirdPartyConfig m_thirdPartyConfig;
    private static final String CONFIG_NAME = "thirdPartyConfig";

    public ThirdPartyConfig getConfig() {
        return this.m_thirdPartyConfig;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_thirdPartyConfig = DefaultSaxParser.parse((String)content);
            this.m_configId = config.getId();
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_thirdPartyConfig = DefaultSaxParser.parse((String)content);
                this.m_configId = config.getId();
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_thirdPartyConfig == null) {
            this.m_thirdPartyConfig = new ThirdPartyConfig();
        }
    }

    public boolean insert(String xml) {
        try {
            this.m_thirdPartyConfig = DefaultSaxParser.parse((String)xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean insert(Http http) {
        Http hp = null;
        String url = http.getUrl();
        for (Http h : this.m_thirdPartyConfig.getHttps()) {
            if (!h.getUrl().equals(url)) continue;
            h.setType(http.getType());
            h.setDomain(http.getDomain());
            h.getPars().clear();
            for (Par par : http.getPars()) {
                h.addPar(par);
            }
            hp = h;
        }
        if (hp == null) {
            this.m_thirdPartyConfig.addHttp(http);
        }
        return this.storeConfig();
    }

    public boolean insert(Socket socket) {
        Socket sk = null;
        String url = socket.getIp();
        int port = socket.getPort();
        for (Socket s : this.m_thirdPartyConfig.getSockets()) {
            if (!s.getIp().equals(url) || s.getPort() != port) continue;
            sk = s;
            s.setDomain(socket.getDomain());
        }
        if (sk == null) {
            this.m_thirdPartyConfig.addSocket(socket);
        }
        return this.storeConfig();
    }

    public boolean remove(String id, String type) {
        if ("http".equals(type)) {
            Http hp = null;
            for (Http h : this.m_thirdPartyConfig.getHttps()) {
                if (!h.getUrl().equals(id)) continue;
                hp = h;
            }
            if (hp != null) {
                this.m_thirdPartyConfig.getHttps().remove(hp);
            }
        } else if ("socket".equals(type)) {
            Socket sk = null;
            String[] info = id.split("-");
            String ip = info[0];
            int port = Integer.valueOf(info[1]);
            for (Socket s : this.m_thirdPartyConfig.getSockets()) {
                if (!s.getIp().equals(ip) || s.getPort() != port) continue;
                sk = s;
            }
            if (sk != null) {
                this.m_thirdPartyConfig.getSockets().remove(sk);
            }
        }
        return this.storeConfig();
    }

    public List<Socket> querSockets() {
        return this.m_thirdPartyConfig.getSockets();
    }

    public List<Http> queryHttps() {
        return this.m_thirdPartyConfig.getHttps();
    }

    public Http queryHttp(String url) {
        List https = this.m_thirdPartyConfig.getHttps();
        for (Http http : https) {
            if (!http.getUrl().equals(url)) continue;
            return http;
        }
        return null;
    }

    public Socket querySocket(String id) {
        String[] infos = id.split("-");
        String ip = infos[0];
        int port = Integer.parseInt(infos[1]);
        List sockets = this.m_thirdPartyConfig.getSockets();
        for (Socket socket : sockets) {
            if (!socket.getIp().equals(ip) || socket.getPort() != port) continue;
            return socket;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        ThirdPartyConfigManager thirdPartyConfigManager = this;
        synchronized (thirdPartyConfigManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.m_thirdPartyConfig.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }
}

