/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.transaction;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.transaction.model.entity.Range;
import com.dianping.cat.consumer.transaction.model.entity.TransactionName;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.entity.TransactionType;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.home.rule.entity.Config;
import com.dianping.cat.home.rule.entity.MonitorRules;
import com.dianping.cat.home.rule.entity.Rule;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.alert.AlertResultEntity;
import com.dianping.cat.report.alert.AlertType;
import com.dianping.cat.report.alert.DataChecker;
import com.dianping.cat.report.alert.sender.AlertEntity;
import com.dianping.cat.report.alert.sender.AlertManager;
import com.dianping.cat.report.alert.transaction.TransactionRuleConfigManager;
import com.dianping.cat.report.page.transaction.transform.TransactionMergeHelper;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.unidal.helper.Splitters;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionAlert
implements Threads.Task,
LogEnabled {
    @Inject(type=ModelService.class, value={"transaction"})
    private ModelService<TransactionReport> m_service;
    @Inject
    private TransactionMergeHelper m_mergeHelper;
    @Inject
    protected TransactionRuleConfigManager m_ruleConfigManager;
    @Inject
    protected DataChecker m_dataChecker;
    @Inject
    protected AlertManager m_sendManager;
    protected Logger m_logger;
    private static String MIN = "min";
    private static String MAX = "max";
    private static String AVG = "avg";
    private static String COUNT = "count";
    private static String FAIL_RATIO = "failRatio";
    private static final int DATA_AREADY_MINUTE = 1;
    protected static final long DURATION = 60000L;

    private double[] buildArrayData(int start, int end, String type, String name, String monitor, TransactionReport report) {
        TransactionType t = report.findOrCreateMachine("All").findOrCreateType(type);
        TransactionName transactionName = t.findOrCreateName(name);
        Map range = transactionName.getRanges();
        int length = end - start + 1;
        double[] datas = new double[60];
        double[] result = new double[length];
        if (AVG.equalsIgnoreCase(monitor)) {
            for (Map.Entry entry : range.entrySet()) {
                datas[((Integer)entry.getKey()).intValue()] = ((Range)entry.getValue()).getAvg();
            }
        } else if (COUNT.equalsIgnoreCase(monitor)) {
            for (Map.Entry entry : range.entrySet()) {
                datas[((Integer)entry.getKey()).intValue()] = ((Range)entry.getValue()).getCount();
            }
        } else if (FAIL_RATIO.equalsIgnoreCase(monitor)) {
            for (Map.Entry entry : range.entrySet()) {
                Range value = (Range)entry.getValue();
                if (value.getCount() <= 0) continue;
                datas[((Integer)entry.getKey()).intValue()] = (double)value.getFails() * 1.0 / (double)value.getCount();
            }
        }
        System.arraycopy(datas, start, result, 0, length);
        return result;
    }

    protected int calAlreadyMinute() {
        long current = System.currentTimeMillis() / 1000L / 60L;
        int minute = (int)(current % 60L) - 1;
        return minute;
    }

    private List<AlertResultEntity> computeAlertForRule(String domain, String type, String name, String monitor, List<Config> configs) {
        ArrayList<AlertResultEntity> results = new ArrayList<AlertResultEntity>();
        Pair conditionPair = this.m_ruleConfigManager.convertConditions(configs);
        int minute = this.calAlreadyMinute();
        HashMap<String, String> pars = new HashMap<String, String>();
        pars.put("type", type);
        pars.put("name", name);
        if (conditionPair != null) {
            int maxMinute = (Integer)conditionPair.getKey();
            List conditions = (List)conditionPair.getValue();
            if (StringUtils.isEmpty((String)name)) {
                name = "All";
            }
            if (minute >= maxMinute - 1) {
                int start = minute + 1 - maxMinute;
                int end = minute;
                pars.put(MIN, String.valueOf(start));
                pars.put(MAX, String.valueOf(end));
                TransactionReport report = this.fetchTransactionReport(domain, ModelPeriod.CURRENT, pars);
                if (report != null) {
                    double[] data = this.buildArrayData(start, end, type, name, monitor, report);
                    results.addAll(this.m_dataChecker.checkData(data, conditions));
                }
            } else if (minute < 0) {
                int start = 60 + minute + 1 - maxMinute;
                int end = 60 + minute;
                pars.put(MIN, String.valueOf(start));
                pars.put(MAX, String.valueOf(end));
                TransactionReport report = this.fetchTransactionReport(domain, ModelPeriod.LAST, pars);
                if (report != null) {
                    double[] data = this.buildArrayData(start, end, type, name, monitor, report);
                    results.addAll(this.m_dataChecker.checkData(data, conditions));
                }
            } else {
                int currentStart = 0;
                int currentEnd = minute;
                int lastStart = 61 - (maxMinute - minute);
                int lastEnd = 59;
                pars.put(MIN, String.valueOf(currentStart));
                pars.put(MAX, String.valueOf(currentEnd));
                TransactionReport currentReport = this.fetchTransactionReport(domain, ModelPeriod.CURRENT, pars);
                pars.put(MIN, String.valueOf(lastStart));
                pars.put(MAX, String.valueOf(lastEnd));
                TransactionReport lastReport = this.fetchTransactionReport(domain, ModelPeriod.LAST, pars);
                if (currentReport != null && lastReport != null) {
                    double[] currentValue = this.buildArrayData(currentStart, currentEnd, type, name, monitor, currentReport);
                    double[] lastValue = this.buildArrayData(lastStart, lastEnd, type, name, monitor, lastReport);
                    double[] data = this.mergerArray(lastValue, currentValue);
                    results.addAll(this.m_dataChecker.checkData(data, conditions));
                }
            }
        }
        return results;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private TransactionReport fetchTransactionReport(String domain, ModelPeriod period, Map<String, String> pars) {
        ModelRequest request = new ModelRequest(domain, period.getStartTime()).setProperty("ip", "All").setProperty("requireAll", "true");
        request.getProperties().putAll(pars);
        ModelResponse response = this.m_service.invoke(request);
        if (response != null) {
            TransactionReport report = (TransactionReport)response.getModel();
            return this.m_mergeHelper.mergeAllNames(report, "All", pars.get("name"));
        }
        return null;
    }

    public String getName() {
        return AlertType.Transaction.getName();
    }

    protected double[] mergerArray(double[] from, double[] to) {
        int i;
        int fromLength = from.length;
        int toLength = to.length;
        double[] result = new double[fromLength + toLength];
        int index = 0;
        for (i = 0; i < fromLength; ++i) {
            result[i] = from[i];
            ++index;
        }
        for (i = 0; i < toLength; ++i) {
            result[i + index] = to[i];
        }
        return result;
    }

    private void processRule(Rule rule) {
        List fields = Splitters.by((String)";").split(rule.getId());
        String domain = (String)fields.get(0);
        String type = (String)fields.get(1);
        String name = (String)fields.get(2);
        String monitor = (String)fields.get(3);
        List alertResults = this.computeAlertForRule(domain, type, name, monitor, rule.getConfigs());
        for (AlertResultEntity alertResult : alertResults) {
            AlertEntity entity = new AlertEntity();
            entity.setDate(alertResult.getAlertTime()).setContent(alertResult.getContent()).setLevel(alertResult.getAlertLevel());
            entity.setMetric(type + "-" + name + "-" + monitor).setType(this.getName()).setGroup(domain);
            this.m_sendManager.addAlert(entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean active = TimeHelper.sleepToNextMinute();
        while (active) {
            Transaction t = Cat.newTransaction((String)"AlertTransaction", (String)TimeHelper.getMinuteStr());
            long current = System.currentTimeMillis();
            try {
                MonitorRules monitorRules = this.m_ruleConfigManager.getMonitorRules();
                Map rules = monitorRules.getRules();
                for (Map.Entry entry : rules.entrySet()) {
                    try {
                        this.processRule((Rule)entry.getValue());
                    }
                    catch (Exception e) {
                        Cat.logError((Throwable)e);
                    }
                }
                t.setStatus("0");
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                Cat.logError((Throwable)e);
            }
            finally {
                t.complete();
            }
            long duration = System.currentTimeMillis() - current;
            try {
                if (duration >= 60000L) continue;
                Thread.sleep(60000L - duration);
            }
            catch (InterruptedException e) {
                active = false;
            }
        }
    }

    public void shutdown() {
    }
}

