/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.graph.metric.impl;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.report.graph.metric.CachedMetricReportService;
import com.dianping.cat.report.page.cdn.graph.CdnReportConvertor;
import com.dianping.cat.report.page.metric.service.MetricReportService;
import com.dianping.cat.report.page.system.graph.SystemReportConvertor;
import com.dianping.cat.report.page.web.graph.WebReportConvertor;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import com.dianping.cat.service.IpService;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedMetricReportServiceImpl
implements CachedMetricReportService {
    @Inject
    private MetricReportService m_reportService;
    @Inject
    private ModelService<MetricReport> m_service;
    @Inject
    private IpService m_ipService;
    private final Map<String, MetricReport> m_metricReports = new /* Unavailable Anonymous Inner Class!! */;

    private MetricReport getReportFromCache(String product, long date) {
        String key = product + date;
        MetricReport result = (MetricReport)this.m_metricReports.get(key);
        if (result == null) {
            Date start = new Date(date);
            Date end = new Date(date + 3600000L);
            try {
                result = (MetricReport)this.m_reportService.queryReport(product, start, end);
                this.m_metricReports.put(key, result);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return result;
    }

    public MetricReport queryCdnReport(String product, Map<String, String> properties, Date start) {
        long time = start.getTime();
        ModelPeriod period = ModelPeriod.getByTime((long)time);
        if (period == ModelPeriod.CURRENT || period == ModelPeriod.LAST) {
            ModelRequest request = new ModelRequest(product, time);
            request.getProperties().putAll(properties);
            if (this.m_service.isEligable(request)) {
                ModelResponse response = this.m_service.invoke(request);
                MetricReport report = (MetricReport)response.getModel();
                return report;
            }
            throw new RuntimeException("Internal error: no eligable metric service registered for " + request + "!");
        }
        MetricReport report = this.getReportFromCache(product, time);
        String cdn = properties.get("cdn");
        String province = properties.get("province");
        String city = properties.get("city");
        CdnReportConvertor cdnReportConvertor = new CdnReportConvertor(this.m_ipService);
        cdnReportConvertor.setProvince(province).setCity(city).setCdn(cdn);
        cdnReportConvertor.visitMetricReport(report);
        return cdnReportConvertor.getReport();
    }

    public MetricReport queryMetricReport(String product, Date start) {
        long time = start.getTime();
        ModelPeriod period = ModelPeriod.getByTime((long)time);
        if (period == ModelPeriod.CURRENT || period == ModelPeriod.LAST) {
            ModelRequest request = new ModelRequest(product, time);
            if (this.m_service.isEligable(request)) {
                ModelResponse response = this.m_service.invoke(request);
                MetricReport report = (MetricReport)response.getModel();
                return report;
            }
            throw new RuntimeException("Internal error: no eligable metric service registered for " + request + "!");
        }
        return this.getReportFromCache(product, time);
    }

    public MetricReport querySystemReport(String product, Map<String, String> properties, Date start) {
        long time = start.getTime();
        ModelPeriod period = ModelPeriod.getByTime((long)time);
        if (period == ModelPeriod.CURRENT || period == ModelPeriod.LAST) {
            ModelRequest request = new ModelRequest(product, time);
            request.getProperties().putAll(properties);
            if (this.m_service.isEligable(request)) {
                ModelResponse response = this.m_service.invoke(request);
                MetricReport report = (MetricReport)response.getModel();
                return report;
            }
            throw new RuntimeException("Internal error: no eligable metric service registered for " + request + "!");
        }
        MetricReport report = this.getReportFromCache(product, time);
        String type = properties.get("type");
        String ipAddrsStr = properties.get("ip");
        HashSet<String> ipAddrs = null;
        if (!"All".equalsIgnoreCase(ipAddrsStr)) {
            String[] ipAddrsArray = ipAddrsStr.split("_");
            ipAddrs = new HashSet<String>(Arrays.asList(ipAddrsArray));
        }
        SystemReportConvertor convert = new SystemReportConvertor(type, ipAddrs);
        convert.visitMetricReport(report);
        return convert.getReport();
    }

    public MetricReport queryUserMonitorReport(String product, Map<String, String> properties, Date start) {
        long time = start.getTime();
        ModelPeriod period = ModelPeriod.getByTime((long)time);
        if (period == ModelPeriod.CURRENT || period == ModelPeriod.LAST) {
            ModelRequest request = new ModelRequest(product, time);
            request.getProperties().putAll(properties);
            if (this.m_service.isEligable(request)) {
                ModelResponse response = this.m_service.invoke(request);
                MetricReport report = (MetricReport)response.getModel();
                return report;
            }
            throw new RuntimeException("Internal error: no eligable metric service registered for " + request + "!");
        }
        MetricReport report = this.getReportFromCache(product, time);
        String city = properties.get("city");
        String channel = properties.get("channel");
        String type = properties.get("type");
        WebReportConvertor convert = new WebReportConvertor(type, city, channel);
        convert.visitMetricReport(report);
        return convert.getReport();
    }
}

