/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.graph.svg;

import com.dianping.cat.report.graph.svg.DefaultGraphBuilder;
import com.dianping.cat.report.graph.svg.GraphBuilder;
import com.dianping.cat.report.graph.svg.GraphPayload;
import com.dianping.cat.report.graph.svg.ValueTranslater;
import java.text.DecimalFormat;
import org.unidal.lookup.annotation.Inject;

public class DefaultGraphBuilder
implements GraphBuilder {
    private static final int BAR = 1;
    private static final int LINE = 2;
    @Inject
    private ValueTranslater m_translater;
    private int m_type = 1;

    public String build(GraphPayload payload) {
        double[] values = payload.getValues();
        double maxValue = this.m_translater.getMaxValue(values);
        XmlBuilder b = new XmlBuilder();
        if (maxValue == 0.0) {
            maxValue = payload.getRows();
        }
        this.buildHeader(payload, b, maxValue);
        this.buildCoordinate(payload, b);
        this.buildYLabels(payload, b, maxValue);
        this.buildXLabels(payload, b);
        if (this.m_type == 1) {
            this.buildBars(payload, b, maxValue, values);
        } else if (this.m_type == 2) {
            this.buildLines(payload, b, maxValue, values);
        }
        this.buildFooter(payload, b);
        return b.getResult().toString();
    }

    protected void buildBars(GraphPayload payload, XmlBuilder b, double maxValue, double[] values) {
        int pixel;
        int i;
        DecimalFormat format = new DecimalFormat("0.#");
        int width = payload.getWidth();
        int height = payload.getHeight();
        int top = payload.getMarginTop();
        int left = payload.getMarginLeft();
        int bottom = payload.getMarginBottom();
        int right = payload.getMarginRight();
        int h = height - top - bottom;
        int w = width - left - right;
        int cols = payload.getColumns();
        int xstep = w / cols;
        int[] pixels = this.m_translater.translate(h, maxValue, values);
        String idPrefix = payload.getIdPrefix();
        b.tag1("g", new Object[]{"id", "bar", "fill", "red"});
        for (i = 0; i < cols && i < pixels.length; ++i) {
            pixel = pixels[i];
            if (pixel <= 0) continue;
            int x = left + xstep * i;
            int y = top + h - pixel;
            b.tag("rect", new Object[]{"id", idPrefix + i, "x", x, "y", y, "width", xstep - 1, "height", pixel});
        }
        b.tag2("g");
        b.tag1("g", new Object[]{"id", "label"});
        for (i = 0; i < cols && i < pixels.length; ++i) {
            pixel = pixels[i];
            if (pixel <= 0) continue;
            double value = values[i];
            int x = left + xstep * i;
            int y = top - 6 + h - pixel;
            String tip = format.format(value);
            if (x + tip.length() * 7 > width - right) {
                x = width - right - tip.length() * 7;
            }
            b.tag1("text", new Object[]{"x", x, "y", y, "display", "none"});
            b.indent().add(tip).newLine();
            b.tag("set", new Object[]{"attributeName", "display", "from", "none", "to", "block", "begin", idPrefix + i + ".mouseover", "end", idPrefix + i + ".mouseout"});
            b.tag2("text");
        }
        b.tag2("g");
    }

    protected void buildCoordinate(GraphPayload payload, XmlBuilder b) {
        int width = payload.getWidth();
        int height = payload.getHeight();
        int top = payload.getMarginTop();
        int left = payload.getMarginLeft();
        int bottom = payload.getMarginBottom();
        int right = payload.getMarginRight();
        int h = height - top - bottom;
        int w = width - left - right;
        int rows = payload.getRows();
        int cols = payload.getColumns();
        int ystep = h / rows;
        int xstep = w / cols;
        PathBuilder p = new PathBuilder();
        b.tag1("g", new Object[]{"id", "coordinate", "stroke", "#003f7f", "fill", "white"});
        b.tag("path", new Object[]{"id", "xy", "d", p.moveTo(left, top + h).h(w).m(-w, 0).v(-h).build()});
        b.tag("path", new Object[]{"id", "xy-2", "d", p.moveTo(left, top).m(w, 0).v(h).build(), "stroke-dasharray", "1,5"});
        b.tag("path", new Object[]{"id", "lines", "d", p.moveTo(left, top).mark().h(w).m(-w, ystep).repeat(rows - 1).build(), "stroke-dasharray", "1,5"});
        if (rows >= 8) {
            p.moveTo(left, top).mark().h(-9).m(9, ystep).h(-5).m(5, ystep).repeat(rows / 2 - 1);
            if (rows % 2 == 0) {
                p.h(-9).m(9, ystep);
            }
            b.tag("path", new Object[]{"id", "ys", "d", p.build()});
        } else {
            p.moveTo(left, top).mark().h(-7).m(7, ystep).repeat(rows);
            b.tag("path", new Object[]{"id", "ys", "d", p.build()});
        }
        if (payload.isAxisXLabelSkipped()) {
            p.moveTo(left, top + h).mark().v(9).m(xstep, -9).v(5).m(xstep, -5).repeat(cols / 2 - 1);
            if (cols % 2 == 0) {
                p.v(9).m(xstep, -9);
            }
            b.tag("path", new Object[]{"id", "xs", "d", p.build()});
        } else {
            p.moveTo(left, top + h).mark().v(7).m(xstep, -7).repeat(cols);
            b.tag("path", new Object[]{"id", "xs", "d", p.build()});
        }
        b.tag2("g");
    }

    protected void buildFooter(GraphPayload payload, XmlBuilder b) {
        b.tag2("svg");
    }

    protected void buildHeader(GraphPayload payload, XmlBuilder b, double maxValue) {
        String axisYTitle;
        int offsetX = payload.getOffsetX();
        int offsetY = payload.getOffsetY();
        int height = payload.getHeight();
        int width = payload.getWidth();
        int top = payload.getMarginTop();
        int left = payload.getMarginLeft();
        int bottom = payload.getMarginBottom();
        int right = payload.getMarginRight();
        if (payload.isStandalone()) {
            b.add("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\r\n");
        }
        b.tag1("svg", new Object[]{"x", offsetX, "y", offsetY, "width", payload.getDisplayWidth(), "height", payload.getDisplayHeight(), "viewBox", "0,0," + width + "," + height, "xmlns", "http://www.w3.org/2000/svg"});
        String title = payload.getTitle();
        if (title != null) {
            b.element("title", title);
        }
        if (payload.getDescription() != null) {
            b.element("description", payload.getDescription());
        }
        b.tag1("g", new Object[0]);
        String axisXTitle = payload.getAxisXTitle();
        if (axisXTitle != null) {
            int x = (width - left - right - axisXTitle.length() * 9) / 2 + left;
            int y = height - 4;
            b.tagWithText("text", (Object)axisXTitle, new Object[]{"x", x, "y", y, "font-size", "18"});
        }
        if ((axisYTitle = payload.getAxisYTitle()) != null) {
            String maxLabel = this.toCompactString(maxValue);
            int x = left - 20 - maxLabel.length() * 9;
            int y = (height - top - bottom + axisYTitle.length() * 9) / 2 + top;
            String transform = "rotate(-90," + x + "," + y + ")";
            b.tagWithText("text", (Object)axisYTitle, new Object[]{"x", x, "y", y, "font-size", "18", "transform", transform});
        }
        if (title != null) {
            int x = (width - left - right - title.length() * 12) / 2 + left;
            int y = 24;
            b.tagWithText("text", (Object)title, new Object[]{"x", x, "y", y, "font-size", "24"});
        }
        b.tag2("g");
    }

    protected void buildLines(GraphPayload payload, XmlBuilder b, double maxValue, double[] values) {
        int pixel;
        int i;
        DecimalFormat format = new DecimalFormat("0.#");
        int width = payload.getWidth();
        int height = payload.getHeight();
        int top = payload.getMarginTop();
        int left = payload.getMarginLeft();
        int bottom = payload.getMarginBottom();
        int right = payload.getMarginRight();
        int h = height - top - bottom;
        int w = width - left - right;
        int cols = payload.getColumns();
        int xstep = w / cols;
        int[] pixels = this.m_translater.translate(h, maxValue, values);
        String idPrefix = payload.getIdPrefix();
        b.tag1("g", new Object[]{"id", "bar", "fill", "red"});
        for (i = 0; i < cols && i < pixels.length; ++i) {
            pixel = pixels[i];
            if (pixel <= 0) continue;
            int x = left + xstep * i;
            int y = top + h - pixel;
            b.tag("rect", new Object[]{"id", idPrefix + i, "x", x, "y", y, "width", xstep - 1, "height", pixel});
        }
        b.tag2("g");
        b.tag1("g", new Object[]{"id", "label"});
        for (i = 0; i < cols && i < pixels.length; ++i) {
            pixel = pixels[i];
            if (pixel <= 0) continue;
            double value = values[i];
            int x = left + xstep * i;
            int y = top - 6 + h - pixel;
            String tip = format.format(value);
            if (x + tip.length() * 7 > width - right) {
                x = width - right - tip.length() * 7;
            }
            b.tag1("text", new Object[]{"x", x, "y", y, "display", "none"});
            b.indent().add(tip).newLine();
            b.tag("set", new Object[]{"attributeName", "display", "from", "none", "to", "block", "begin", idPrefix + i + ".mouseover", "end", idPrefix + i + ".mouseout"});
            b.tag2("text");
        }
        b.tag2("g");
    }

    protected void buildXLabels(GraphPayload payload, XmlBuilder b) {
        int height = payload.getHeight();
        int width = payload.getWidth();
        int left = payload.getMarginLeft();
        int bottom = payload.getMarginBottom();
        int right = payload.getMarginRight();
        int cols = payload.getColumns();
        int w = width - left - right;
        int xstep = w / cols;
        b.tag1("g", new Object[]{"id", "xt"});
        boolean rotated = payload.isAxisXLabelRotated();
        boolean skipped = payload.isAxisXLabelSkipped();
        int i = 0;
        while (i <= cols) {
            int x = left + xstep * i - 4;
            int y = height - bottom + 20 + (skipped ? 2 : 0);
            String label = payload.getAxisXLabel(i);
            if (!rotated) {
                if (label.length() > 1) {
                    x -= 4 * (label.length() - 1);
                }
            } else {
                y -= 10;
            }
            if (rotated) {
                String transform = "rotate(90," + x + "," + y + ")";
                b.tagWithText("text", (Object)label, new Object[]{"x", x, "y", y, "font-size", "14", "transform", transform});
            } else {
                b.tagWithText("text", (Object)label, new Object[]{"x", x, "y", y, "font-size", "14"});
            }
            if (skipped) {
                i += 2;
                continue;
            }
            ++i;
        }
        b.tag2("g");
    }

    protected void buildYLabels(GraphPayload payload, XmlBuilder b, double maxValue) {
        int height = payload.getHeight();
        int top = payload.getMarginTop();
        int left = payload.getMarginLeft();
        int bottom = payload.getMarginBottom();
        int h = height - top - bottom;
        int rows = payload.getRows();
        int ystep = h / rows;
        b.tag1("g", new Object[]{"id", "yt", "direction", "rtl"});
        if (rows >= 8) {
            for (int i = 0; i < rows; i += 2) {
                int x = left - 12;
                int y = top + 4 + ystep * i;
                b.tagWithText("text", (Object)this.toCompactString(maxValue - maxValue / (double)rows * (double)i), new Object[]{"x", x, "y", y, "font-size", "14"});
            }
        } else {
            for (int i = 0; i < rows; ++i) {
                int x = left - 9;
                int y = top + 4 + ystep * i;
                b.tagWithText("text", (Object)this.toCompactString(maxValue - maxValue / (double)rows * (double)i), new Object[]{"x", x, "y", y, "font-size", "14"});
            }
        }
        b.tag2("g");
    }

    public void setGraphType(int GraphType) {
    }

    private String toCompactString(double value) {
        return new DecimalFormat("0.##").format(value);
    }
}

