/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.home.group.entity.Domain;
import com.dianping.cat.home.group.entity.DomainGroup;
import com.dianping.cat.home.group.entity.Group;
import com.dianping.cat.home.group.transform.DefaultSaxParser;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainGroupConfigManager
implements Initializable {
    @Inject
    private ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    private int m_configId;
    private DomainGroup m_domainGroup;
    private static final String CONFIG_NAME = "domainGroup";

    public DomainGroup getDomainGroup() {
        return this.m_domainGroup;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_domainGroup = DefaultSaxParser.parse((String)content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_domainGroup = DefaultSaxParser.parse((String)content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_domainGroup == null) {
            this.m_domainGroup = new DomainGroup();
        }
    }

    public boolean insert(String xml) {
        try {
            this.m_domainGroup = DefaultSaxParser.parse((String)xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean insertFromJson(String json) {
        try {
            Domain domain = (Domain)new JsonBuilder().parse(json, Domain.class);
            this.m_domainGroup.addDomain(domain);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean deleteGroup(String domain) {
        this.m_domainGroup.removeDomain(domain);
        return this.storeConfig();
    }

    public String queryDefaultGroup(String domain) {
        List groups = this.queryDomainGroup(domain);
        if (groups.size() >= 1) {
            return (String)groups.get(0);
        }
        return "";
    }

    public Domain queryGroupDomain(String domain) {
        Domain domainGroup = this.m_domainGroup.findDomain(domain);
        return domainGroup;
    }

    public List<String> queryDomainGroup(String domain) {
        Domain domainGroup = this.m_domainGroup.findDomain(domain);
        if (domainGroup == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(domainGroup.getGroups().keySet());
    }

    public List<String> queryIpByDomainAndGroup(String domain, String group) {
        Group groupInfo;
        Domain domainInfo = this.m_domainGroup.findDomain(domain);
        if (domainInfo != null && (groupInfo = domainInfo.findGroup(group)) != null) {
            return groupInfo.getIps();
        }
        return new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        DomainGroupConfigManager domainGroupConfigManager = this;
        synchronized (domainGroupConfigManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.m_domainGroup.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }
}

